
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMVERI.CPP   1.13   13 Dec 1996 11:19:02   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMVERI.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:02   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:00   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:18   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:30   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:04   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:46   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:14   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:20   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:42   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:42   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMVERI.CPP
//
//  Description: The implementation file for the class: CMemoryVerify.
//
//  Author: Chen Jun
//
//  Date: 05/29/95
//
//  Modification:
//      1. 05/29/95, Initial version of the class: CMemoryVerify.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memveri.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
unsigned char uchMemVerifyFlag = 0;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void VerifyCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiSetVerify(FLAG uVerifyFlag);
//#endif  // _SERVER_NO_ABI


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   VerifyCmd().
//
//  Description: The main control routine of Verify command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void VerifyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Verify EMM contents.
    CMemoryVerify* pMemoryVerify = new CMemoryVerify;
    if ( !pMemoryVerify ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pMemoryVerify->VerifyAction(nArgc, pszArgv);
        delete pMemoryVerify;
    }

//    CMemoryVerify objVerify;
//    objVerify.MemoryVerify(nArgc, pszArgv);

}   // End of VerifyCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryVerify.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::CMemoryVerify().
//
//  Description: The construction of the class: CMemoryVerify.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryVerify::CMemoryVerify()
{

}   // End of CMemoryVerify::CMemoryVerify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::~CMemoryVerify().
//
//  Description: The destruction of the class: CMemoryVerify.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryVerify::~CMemoryVerify()
{

}   // End of CMemoryVerify::~CMemoryVerify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::VerifyAction().
//
//  Description: Verify for EMM accessing.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryVerify::VerifyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Verify command kernel.
    if ( 1 == nArgc ) {
        // Verify
        DisplayVerify();
    }
    else if ( 2 == nArgc ) {
        if ( !stricmp(pszArgv[1], "ON") ) {
            // Verify ON
            SetVerifyOn();
        }
        else if ( !stricmp(pszArgv[1], "OFF") ) {
            // Verify OFF
            SetVerifyOff();
        }
        else {
            return;
        }
    }
    else {
        return;
    }
    
}   // End of CMemoryVerify::VerifyAction().


// Set Verify On.
void CMemoryVerify::SetVerifyOn(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI routine.
    m_nErrorID = AbiSetVerify(1);
    if ( ICE_OK == m_nErrorID ) {
        uchMemVerifyFlag = 1;
    }
    else {
        DisplayErrorMessage();
    }
    
}   // End of CMemoryVerify::SetVerifyOn().


// Set Verify Off.
void CMemoryVerify::SetVerifyOff(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI routine.
    m_nErrorID = AbiSetVerify(0);
    if ( ICE_OK == m_nErrorID ) {
        uchMemVerifyFlag = 0;
    }
    else {
        DisplayErrorMessage();
    }
    
}   // End of CMemoryVerify::SetVerifyOff().


// Display the current Verify status.
void CMemoryVerify::DisplayVerify(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == uchMemVerifyFlag || 1 == uchMemVerifyFlag );
    
    // Display the Verify status.
    if ( 1 == uchMemVerifyFlag ) {
        ShowLine("Verify ON.");
    }
    else if ( 0 == uchMemVerifyFlag ) {
        ShowLine("Verify OFF.");
    }
    else {
        return;
    }

}   // End of CMemoryVerify::DisplayVerify().


//////////////////////////////// End of File ////////////////////////////////
