
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMWIVW.H__   1.13   13 Dec 1996 11:19:04   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMWIVW.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:04   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:02   ZJRD
** PIC/SLD Version 0.97
** 
**    Rev 1.11   11 Nov 1996 12:47:20   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:16   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:58   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:56   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:30   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:46   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:24   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:32   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:46   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:10   ZJRD
** Initial revision.
** 
****************************************************************************/

// memwivw.h : interface of the CMemwinView class
//
/////////////////////////////////////////////////////////////////////////////
#include "memlay.h"
#include "memdsm.h"
#include "memwidoc.h"

class CMemwinView : public CView
{
protected: // create from serialization only
	CMemwinView();
	DECLARE_DYNCREATE(CMemwinView)

// Attributes
public:
	CMemwinDoc* GetDocument();
    CMemDsm* m_pMemDsm;   
    BOOL m_isDsm; 
    int m_nLines;
    CString m_searchStr;
// Operations
public:

// Implementation
public:
	virtual ~CMemwinView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
    CPoint m_ptFirst; 
    CSize m_szScroll;
//    CMemLayout * m_pMemLayout;
    CRect m_rectClient; 
    BOOL m_isByte; 
    int m_nCellEndPos; 
    BOOL m_isSelected;         
private:
	int m_nCellsPerLine;  //8 or 16
	int m_nLineHeight;
	int m_nColWidth; 
	int m_nAddrColWidth;
	CPoint m_ptCaretPos; 
    CSize m_szFont;           
    int m_nPageRange;

	BOOL m_isSigned;
	int m_nHexORDec;           

	int m_nFirstViewableCol; 
	
	void SetCellEndPos();
	void CaretMove(int flag);  
	CMemLayout * m_pMemLayout;   
// Operations
public:

// Implementation
public:
    int CaretPos2Col(int);
    CRect Caret2Cell(CPoint pt);
    int GetGridWidth();
	// Generated message map functions
protected:          
    void GotoAddress(long address); 
	BOOL CaretOnWndEdge();
	BOOL InputCheck( UINT nChar,int N, BOOL bSign,BOOL isByte); 
	void DrawGrid(CDC* pDC,int nCols,int nRows);
	void DrawLine(CDC* pDC,int line);  
	void DrawNewData(CDC* pDC);
	void SetMemCaretPos(CPoint);
	CPoint Point2Cell(CPoint);
	BOOL HitTest(CPoint);
	//{{AFX_MSG(CMemwinView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnViewHex();
	afx_msg void OnViewSigned();
	afx_msg void OnViewUnsigned();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditSearch();
	afx_msg void OnEditSearchnext();
	afx_msg void OnEditGoto();
	afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnViewDisassemble();
	afx_msg void OnUpdateViewDisassemble(CCmdUI* pCmdUI);
	afx_msg void OnGroupMemory();
	afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewRefresh();
	//}}AFX_MSG
	afx_msg LONG OnXmGetMem(UINT,LONG);  
	afx_msg LONG OnXmRepaint(UINT,LONG);
//	afx_msg LONG ONTmRefresh(UINT w,LONG l);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in memwivw.cpp
inline CMemwinDoc* CMemwinView::GetDocument()
   { return (CMemwinDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
