
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMWORD.CPP   1.13   13 Dec 1996 11:19:04   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMWORD.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:04   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:04   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:10   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:22   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:38   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:58   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:00   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:29:12   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:08   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMWORD.CPP
//
//  Description: The implementation file for the class: CMemoryWord.
//
//  Author: Chen Jun
//
//  Date: 06/20/95
//
//  Modification:
//      1. 06/20/95, Initial version of the class: CMemoryWord.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memword.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void WordCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
//#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   WordCmd().
//
//  Description: The main control routine of Word command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void WordCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Word to EMM.
    char error[128];    
    CMemoryWord* pMemoryWord = new CMemoryWord;
    if ( !pMemoryWord ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
           pMemoryWord->WordAction(nArgc, pszArgv);
           delete pMemoryWord;
          }           
       }   
    }

//    CMemoryWord objWord;
//    objWord.SetWord(nArgc, pszArgv);

}   // End of WordCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryWord.

// The construction of the class: CMemoryWord.
CMemoryWord::CMemoryWord()
{

}   // End of CMemoryWord::CMemoryWord().


// The destruction of the class: CMemoryWord.
CMemoryWord::~CMemoryWord()
{

}   // End of CMemoryWord::~CMemoryWord().


// Set the Word value to EMM.
void CMemoryWord::WordAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Word adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_Addr.m_uchType = MEM_EXTERNAL;
        m_Addr.m_uchType = MEM_PROGRAM;
    }
    
    // Memory Word kernel routine.
    MemoryWordKernel();
        
}   // End of CMemoryWord::WordAction().


void CMemoryWord::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[5];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 4; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
//        ((WORD*) m_pchByte)[m_uPatternLen/2] = (WORD) m_ulVar;
//        m_uPatternLen += 2;
        if ( m_Addr.m_uchType == MEM_PROGRAM ) {
	        m_pchByte[m_uPatternLen] = (WORD) m_ulVar;
	        m_uPatternLen ++;
	    }
	    else {
	        m_pchByte[m_uPatternLen++] = (BYTE) m_ulVar;
	        m_pchByte[m_uPatternLen++] = (BYTE) (m_ulVar>>8);
	    }
    }

}   // End of CMemoryWord::SetPattern().


void CMemoryWord::MemoryWordKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_Addr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryWord::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
