
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MISC.CPP   1.13   13 Dec 1996 11:19:12   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MISC.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:12   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:10   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:28   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:24   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:34   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:50   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:06   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:45:40   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:32:34   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:28   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.1   15 Aug 1996 10:05:56   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:20   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : MISC.CPP 
** Author:john chow
** Description:
**
**
**    Finished date:
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#include "stdafx.h"
#include "stdlib.h"
#include "string.h"

#include "abibase.h"     
#include "abitype.h" 
#include "abibase.h"
#include "cpucom.h"
#include "cpuserve.h"
#include "hosterrs.h"

#include "abiextfn.h"

#define IDEA 0
#define IDRESET 1    
#define IDEBEN 2
#define IDDISABLE 0
#define IDENABLE 1


extern void ShowLine(char*);
extern void CpuShowAllRegToWnd();
extern int GetControlOption(CString &strMclr,CString &strWdg,CString &strPeri);

void DisplayErrorMessage(int nErrorID);
void DisplayErrorMessageBox(int nErrorID);

/**********************************************
** input : bType        0 : LOWPOWER(LP)
**                      1 : XT
**                      2 : HS
**                      3 : RC
**
**
************************************************/
STATUS SetClock(BYTE bType) 
{ 
    STATUS nResult;
    FLAG bControlFlag;
    BYTE bTmp = bType;
    
    nResult = AbiGetControl(&bControlFlag);
    if (ICE_OK != nResult) return nResult;
    
    bType = bType<<1;
    bControlFlag = (bControlFlag & 0xf9) | bType;
    nResult = AbiSetControl(bControlFlag);   
    if (ICE_OK != nResult) return nResult;         
    AfxGetApp()->WriteProfileInt("CLOCK", "TYPE", bTmp);         
    return ICE_OK;
    
 }

/**********************************************
** input : bType        0 : LOWPOWER(LP)
**                      1 : XT
**                      2 : HS
**                      3 : RC
**
**
************************************************/
STATUS GetClock(BYTE &bType) 
{ 
    STATUS nResult;
    
    nResult = AbiGetControl(&bType);
    if (ICE_OK != nResult) return nResult;
    
    bType = ((bType>>1)<<6)>>6;
    return ICE_OK;
    
 }

/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS SetReset(BYTE bType) 
{ 
    STATUS nResult;
    FLAG bControlFlag;
    
    nResult = AbiGetControl(&bControlFlag);
    if (ICE_OK != nResult) return nResult;
    
    bControlFlag = (bControlFlag & 0xfe) | bType;
    return AbiSetControl(bControlFlag);
    
 }


/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS GetReset(BYTE &bType) 
{ 
    STATUS nResult;
    
    nResult = AbiGetControl(&bType);
    if (ICE_OK != nResult) return nResult;
    
    bType = ((bType&0x01)<<7)>>7;     
    return ICE_OK;
    
 }

/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS SetWatchDog(BYTE bType) 
{ 
    STATUS nResult;
    FLAG bControlFlag;
    
    nResult = AbiGetControl(&bControlFlag);
    if (ICE_OK != nResult) return nResult;
    
    bType = bType<<3;
    bControlFlag = (bControlFlag & 0xf7) | bType;
    return AbiSetControl(bControlFlag);
    
 }


/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS GetWatchDog(BYTE &bType) 
{ 
    STATUS nResult;
    
    nResult = AbiGetControl(&bType);
    if (ICE_OK != nResult) return nResult;
// Modified by Gates Hua    
//    bType = ((bType>>3)<<7)>>7;
    bType = (bType&0x8)>>3;
    return ICE_OK;
    
 }

/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS SetPrepherial(BYTE bType) 
{ 
    STATUS nResult;
    FLAG bControlFlag;
    
    nResult = AbiGetControl(&bControlFlag);
    if (ICE_OK != nResult) return nResult;
    
    
    bType = bType<<4;
    bControlFlag = (bControlFlag & 0xef) | bType;
    return AbiSetControl(bControlFlag);
    
 }


/**********************************************
** input : bType        0 : disable
**                      1 : enable
**
**
************************************************/
STATUS GetPrepherial(BYTE &bType) 
{ 
    STATUS nResult;
    
    nResult = AbiGetControl(&bType);
    if (ICE_OK != nResult) return nResult;
// Modified by Gates Hua    
//    bType = ((bType>>4)<<7)>>7;
    bType = (bType&0x10)>>4;
    return ICE_OK;
    
 }


void ClockCmd(int nArgc, char* pszArgv[])
{
    FLAG   bType;
    int    nErrorID;             

    if(1== nArgc) {  
      nErrorID = GetClock(bType);       
      if(ICE_OK == nErrorID) {
          switch(bType) {         
              case 0 : ShowLine("clock type : LOWPOWER"); break;
              case 1 : ShowLine("clock type : XT"); break;
              case 2 : ShowLine("clock type : HS"); break;
              case 3 : ShowLine("clock type : RC"); break;
          }    
      } else DisplayErrorMessage(nErrorID);
      return;
    }        
    
    CString strTmp = strupr(pszArgv[1]);
    
    if ("LOWPOWER" == strTmp) {
        nErrorID = SetClock(0);           
        if(ICE_OK == nErrorID) {
              ShowLine("Clock is set to LOWPOWER type.");
        } else DisplayErrorMessage(nErrorID);
        return;
    }
    
    if ("XT" == strTmp) {
        nErrorID = SetClock(1);           
        if(ICE_OK == nErrorID) {
              ShowLine("Clock is set to XT type.");
        } else DisplayErrorMessage(nErrorID);
        return;
    }                                     
    
    if ("HS" == strTmp) {
        nErrorID = SetClock(2);           
        if(ICE_OK == nErrorID) {
              ShowLine("Clock is set to HS type.");
        } else DisplayErrorMessage(nErrorID);
        return;
    }                                     
    
    if ("RC" == strTmp) {
        nErrorID = SetClock(3);           
        if(ICE_OK == nErrorID) {
              ShowLine("Clock is set to RC type.");
        } else DisplayErrorMessage(nErrorID);
        return;
    }
    
    return;
}          

void ControlCmd(int nArgc, char* pszArgv[])
{
FLAG   bType;
int    nErrorID;             
CString strTmpMCLR,strTmpWatchDog,strTmpPERIPHERAL,strTmp;                         
	GetControlOption(strTmpMCLR,strTmpWatchDog,strTmpPERIPHERAL);

    if(1== nArgc) {   
    
        strTmp = strTmpMCLR;
        if("MCLR" == strTmp) {
            nErrorID=GetReset(bType);
            if(ICE_OK == nErrorID) {
                if(1 == bType)
                    ShowLine("MCLR is enable.");
                else
                    ShowLine("MCLR is disable.");
            } else DisplayErrorMessage(nErrorID);
        }
        strTmp = strTmpWatchDog;                
        if ("WATCHDOG" == strTmp) {
            nErrorID=GetWatchDog(bType);
            if(ICE_OK == nErrorID) {
                if(1 == bType)
                    ShowLine("WATCHDOG is enable.");
                else
                    ShowLine("WATCHDOG is disable.");
            } else DisplayErrorMessage(nErrorID);
        }
                                            
// Modified by Gates Hua 
/*   
        strTmp = strTmpPERIPHERAL;                                                            
        if ("PERIPHERAL" == strTmp) {
            nErrorID=GetPrepherial(bType);
            if(ICE_OK == nErrorID) {
                if(1 == bType)
                    ShowLine("PERIPHERAL is enable.");
                else
                    ShowLine("PERIPHERAL is disable.");
            } else DisplayErrorMessage(nErrorID);
        }             
*/        
        return;
    }          
    
    if(3==nArgc) { 
        
        strTmp = strupr(pszArgv[1]);
        if("MCLR" == strTmp) {       
            strTmp = strupr(pszArgv[2]);
            if("ENABLE" == strTmp) {
                nErrorID = SetReset(1);
                if(ICE_OK == nErrorID) {
                        ShowLine("MCLR is enable.");
                } else DisplayErrorMessage(nErrorID);                
            } else {
                nErrorID = SetReset(0);                              
                if(ICE_OK == nErrorID) {
                        ShowLine("MCLR is disable.");
                } else DisplayErrorMessage(nErrorID);                
            }    
        } 

        if("WATCHDOG" == strTmp) {       
            strTmp = strupr(pszArgv[2]);
            if("ENABLE" == strTmp) {
                nErrorID = SetWatchDog(1);
                if(ICE_OK == nErrorID) {
                        ShowLine("WATCHDOG is enable.");
                } else DisplayErrorMessage(nErrorID);                
            } else {
                nErrorID = SetWatchDog(0);                              
                if(ICE_OK == nErrorID) {
                        ShowLine("WATCHDOG is disable.");
                } else DisplayErrorMessage(nErrorID);                
            }    
        } 
        
// Modified by Gates Hua 
/*        
        if("PERIPHERAL" == strTmp) {       
            strTmp = strupr(pszArgv[2]);
            if("ENABLE" == strTmp) {
                nErrorID = SetPrepherial(1);
                if(ICE_OK == nErrorID) {
                        ShowLine("PERIPHERAL is enable.");
                } else DisplayErrorMessage(nErrorID);                
            } else {
                nErrorID = SetPrepherial(0);                              
                if(ICE_OK == nErrorID) {
                        ShowLine("PERIPHERAL is disable.");
                } else DisplayErrorMessage(nErrorID);                
            }    
        } 
*/        
        return;    
    }      
    
    return;       
}


void InportCmd(int nArgc, char* pszArgv[])
{
BYTE  portval;
unsigned char  nPort;
char     DisplayStr[28];
int      nErrorID;
int      i;

    nPort = pszArgv[1][0];
    nPort = toupper(nPort);
    nPort = nPort - 'A';
    ASSERT(nPort <= 7);

    switch(nPort)
    {
        case 0:
            nErrorID = AbiInput(PORT_RA, &portval);
            break;
        case 1:
            nErrorID = AbiInput(PORT_RB, &portval);
            break;
        case 2:
            nErrorID = AbiInput(PORT_RC, &portval);
            break;
        case 3:
            nErrorID = AbiInput(PORT_RD, &portval);
            break;
        case 4:
            nErrorID = AbiInput(PORT_RE, &portval);
            break;
        case 5:
            nErrorID = AbiInput(PORT_RF, &portval);
            break;
        case 6:
            ASSERT(0);
            break;    
    }
    if(ICE_OK == nErrorID)
    {
        if (nArgc == 2)
        {
            CString str("");
            wsprintf(str.GetBuffer(30),"P%01X value is ",nPort);
            str.ReleaseBuffer();
            CString bitstr("");
            for(i = 7;i >=0 ; i --)
            {
                if(_rotl(1,i)&portval)
                    bitstr="1";
                else
                    bitstr="0";
                str+=bitstr;
            }          
            str+='B';
            ShowLine(str.GetBuffer(30)); str.ReleaseBuffer();
        }
        if (nArgc == 3)
        {
            wsprintf(DisplayStr,"P%01X value is %02X", nPort,portval);
            ShowLine(DisplayStr);
        }
        if(nArgc == 4)
        {
            int nBit = atoi(pszArgv[3]);
            ASSERT(nBit<8);
            wsprintf(DisplayStr,"P%01X bit%i is %01i",nPort,nBit,
                ((portval<<(7-nBit))>>7) );
            ShowLine(DisplayStr);
        }
    }        
    else
        DisplayErrorMessage(nErrorID);
}


void OutportCmd(int nArgc, char* pszArgv[])
{
unsigned char portval;
unsigned char  nPort;
char*    stop_at;
unsigned char mask=0x01;

    nPort = pszArgv[1][0];
    nPort = toupper(nPort);
    nPort = nPort - 'A';
    ASSERT(nPort <= 7);

    if (nArgc == 4)
    {
        portval = (unsigned short)strtoul(pszArgv[3],&stop_at,16);
        AbiOutput((PARA_PORT)nPort,portval,0x00);  //maskflag = 1, unmask.= 0
    }                    
    
    if(nArgc == 6)
    {
        portval = (unsigned short)strtoul(pszArgv[5],&stop_at,16);
        mask = (unsigned short)strtoul(pszArgv[3],&stop_at,16);
        AbiOutput((PARA_PORT)nPort,portval,mask);
    }
}
  
void DisplayErrorMessage(int nErrorID)
{
  //FOR  Display the ABI error message using
    char     pszAbiError[150];

    ErrGetErrorText(ER_ICE_OK+nErrorID, pszAbiError);
    ShowLine(pszAbiError);
}   // End of CCpuServer::DisplayErrorMessage().

void DisplayErrorMessageBox(int nErrorID)
{                                        
   //FOR  Display the ABI error message using
    ErrDisplayError(ER_ICE_OK+nErrorID);
}   // End of CCpuServer::DisplayErrorMessageBox().


//////////////////////////////(EOF)/////////////////////////////
