 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ORDTBL.H__   1.13   13 Dec 1996 11:19:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ORDTBL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:32   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:10   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:20   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:38   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:56   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:58   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:10   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:08   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:52   ZJRD
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: ordtbl.h
**
** Title: Ordinal Table
**
** Purpose:
**  Class and methods for managing the ordinal table - list of offsets to
**  symbols in the order they are loaded.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/PICSLDV/SRC/LOG/ORDTBL.H__   1.13   13 Dec 1996 11:19:18   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _ORDTBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "mempool.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 ORDINAL_INDEX;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

class OrdinalTable : public MemPool {

public:

//------------------------------------------------------------------------
// OrdinalTable() - contructor
//
// Purpose:
//    Initialize ordinal table variables for table creation and expansion.
//---------------------------------------------------------------------------
OrdinalTable();    // constructor


//------------------------------------------------------------------------
// AddSymOffsetToOT
//
// Purpose:
//    Put the offset to the symbol into the next free space in the ordinal
//    table.  Return the index number where loaded.
//
// Input parameters:
//    symOffset:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    ordinalIndex:
//       ORDINAL_INDEX index (into ordinal table) where symbol offset placed
//
// Error:
//    Returns calling error messages
//------------------------------------------------------------------------
RETCODE
AddSymOffsetToOT(TABLE_OFFSET symOffset, ORDINAL_INDEX& ordIndex);


//------------------------------------------------------------------------
// GetOffset
//
// Purpose:
//    Retrieve offset to symbol table item given the index to the ordinal
//    table.
//
// Input parameters:
//    ordIndex:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL or
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       last item in the table or larger than the table size
//------------------------------------------------------------------------
RETCODE GetOffset(ORDINAL_INDEX ordIndex,
                  TABLE_OFFSET& itemOffset);


//------------------------------------------------------------------------
// GetOrdinalCount
//
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
U32 GetOrdinalCount(void) { return (GetAvailMemOffset()
                            / sizeof(TABLE_OFFSET)); };

//------------------------------------------------------------------------
// GetOrdinalFromPercent
//
// Purpose:
//    Given a percentage value (0 - 100), return the ordinal value
//    (location) closest to the percentage value requested.
//    e.g. 0  (%) = first location
//         100(%) = last location
//
// Input parameter:
//    percent: desired percentage of total entry count
//
// Return value:
//    ordinal index (0 to n) that is the closest to the percentage of the
//    total table size requested
//
// Errors: No errors; limits percent to 100
//------------------------------------------------------------------------
U32 GetOrdinalFromPercent(U8 percent);

//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
void ObliterateTable(void);

};  // end of class OrdinalTable

#define _ORDTBL_
#endif
/******************************** E O F *************************************/
