/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/PICADDR.H__   1.13   13 Dec 1996 11:19:26   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/PICADDR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:19:26   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:26   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:44   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:40   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:00   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:58   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:32   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:52   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:30   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:09:52   ZJRD
** PIC/SLD Version 0.20
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      PICADDR.h
**
**  Description:  The sub class CPicadr deprived from the CFormatAddress
**                This class is process the PICxx base family address
**                PICxx base family address has the format as following
**                      prefix:address
**                prefix is the space area. Those are :
**                      p: program
**                      i: internal
**                The address has two format: Hex and Dec
**                      Hex has the prefix before address that is 0x or not
**
**                Another : the address is a symbol. The symbol has the format
**                as following:
**                      #ModuleName#SymbolName etc.
**                The process must deal all the statment described as before.
**
**  Status: Initialization
**          1996/05/28        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __CPICADR__H
#define __CPICADR__H


class CPicAddress : CFormatAddress
{
   private:
      BOOL     IsString;               // Construct from a string;
 ADDR_RETCODE  m_enumRetCode;          // Return code

      // Attribute
      CString  m_strSpace;             // The address space text string,
                                       // 'p'-->'Program';
   ADDR_SPACE  m_enumSpace;            // The enum space

   private:
      // Implenmentation
      void  Initialize();                    // Initialize all attributes
      BOOL  Process(CFormatType *format);    // Process the address server
      
      void  AdrToRegID();                    // Convert address to reg ID
      
   public:
      //Constructor
      CPicAddress() {
         Initialize();
      }
      
      CPicAddress(const CString& str);        // from CString
      CPicAddress(const LPSTR lpsz);          // from LPSTR
      CPicAddress(const CString& str,
                  const UINT isHex);          // from CString
      CPicAddress(const LPSTR lpsz,
                  const UINT isHex);          // from LPSTR
      CPicAddress(ADDR_SIZE dw);              // from ADDR_SIZE
      CPicAddress(ADDRESS  adr);              // from ADDRESS struct
      //C51Address(const C51Address &c51adr);// copy constructor

      //Inline function
      CString GetHexAddr();
      CString GetDecAddr();
 ADDR_RETCODE GetRetCode();
 ADDR_SPACE   GetSpace();
 ADDR_SIZE    GetAddress();
 
      // virtual function deprived from parent class
      virtual BOOL  ConvertCheck();                  // Convert the address and
                                                     // check it

      virtual BOOL  SplitPrefix(const char* lpsz);   // Split the prefix and
                                                     // address
};

#endif

////////////////////////////////(EOF)////////////////////////////////////////
