/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SERIALCM.H__   1.13   13 Dec 1996 11:20:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SERIALCM.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:58   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:12   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:10   ZJRD
** PIC/SLD Version 0.95
** 
**    Rev 1.9   02 Nov 1996 09:47:42   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:04   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:52   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:08   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:42   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:04   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:18   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:24   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:06   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : SERIALCM.H
** Author:john chow
** Description:
**    Descript the base function of serial communication for PIC
**
**    Finished date: 96.7
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#ifndef _SERIALCM_
#define _SERIALCM_

#include "stdafx.h"
#include <sys\timeb.h>
#include <string.h>
#include "abitype.h"

//const define

#define MAXERRORNUM 200              

// definition of CBaseCom
class CBaseCom 
{   
//member
public:
    int m_nError;
    int m_nDetailError;
    BOOL m_isCanBeUsed;                  
    
    enum { ERR_NO,ERR_NOT_REPARE,ERR_TIME_OUT,ERR_ESC,ERR_FATAL};
private:
    struct _timeb m_startTime,m_currentTime;
    unsigned long m_lTimer; 
   
//operation
public:  
    virtual BOOL SendByte(BYTE) = 0;
    virtual BOOL ReceiveByte(BYTE&) = 0;
    virtual BOOL SendString(BYTE *,int);
    virtual BOOL ReceiveString(BYTE *,int);
    virtual BOOL IsEscape() { return FALSE;}
    virtual void FlushBufferIn() {return ;}
    virtual void FlushBufferOut() {return ;}
    
    void SetTimer(unsigned long);
    void RestartTimer();
    
    BOOL IsTimeOut();
    
//construct
protected:
    CBaseCom() { 
        m_isCanBeUsed = FALSE; 
        m_nError = m_nDetailError = ERR_NO;}       
};

//definition of class CBaseAgree
class CBaseAgree : public CBaseCom
{
//member
public:
    BYTE *m_strInput,*m_strOutput;  
    WORD m_nInputStrLen,m_nOutputStrLen;
    BYTE bRelinkTimes;  
    enum { INPUTLEN = 2048,OUTPUTLEN = 4096 };
//operation
public:
    void SetOutputStr(BYTE*,int);   
    void GetInputStr(BYTE*,int&);
    
    virtual BOOL Do() = 0;
//construct and destruct
protected:
    CBaseAgree();
    ~CBaseAgree();  
};  

//definition of class CPICAgree
class CPICAgree : public CBaseAgree
{                                 
//member
public:
    BOOL isConnected;
    BYTE bRelinkTimes;  
    enum { 
        ERR_RELINKQUIT = 200,
        ERR_RECEIVE_WRONGCODE,
        ERR_NOT_CONNECTED,
        ERR_RECEIVE_DOLLAR,
        ERR_SEND_DOLLAR,
        ERR_SHAKE_HAND,
        ERR_SEND_HEAD,
        ERR_SEND_REC,
        ERR_SHAKE_HAND_,
        ERR_RECEIVE_HEAD,
        ERR_RECEIVE_REC
    };
    unsigned long nBackTime;//setted by every abi command to define the inter time
                    //between send string to fw and receive string from fw
                    
    
private:
    enum {       
        LEAD_CODE   = ':',
        HEAD_OK     = 0x55,
        HEAD_FAIL   = 0xaa,
        REC_OK      = 0x5a,   
        REC_FAIL    = 0xa5
    };      
    int m_nErrorTime;//counter of error
            
//operation 
public:
    virtual BOOL IsRelink() { return FALSE; }
    virtual BOOL Do();
    virtual void IsUnstable() = 0;
                      
    BOOL Init();                  
    BOOL Shakehand(BYTE bTimers = 10);
    BOOL Shakehand_();
    BOOL SendHead();
    BOOL SendRec();
    BOOL ReceiveHead();
    BOOL ReceiveRec();
    

//construct
protected:
    CPICAgree() { isConnected == FALSE; m_nErrorTime = 0; } 
    
};                   

//definition of class CBaseSerialPICAgree
class CBaseSerialPICAgree : public CPICAgree
{                                        
//members
public:
    enum {
        COM_PORT_1 = 0,
        COM_PORT_2,
        COM_PORT_3,
        COM_PORT_4
    };
    enum {
        BAUD_9600 = 0,
        BAUD_19200,
        BAUD_38400,
        BAUD_57600,
        BAUD_115200
    };  
    enum {
        CLOCK_LP = 0,
        CLOCK_XT,
        CLOCK_HS,
        CLOCK_RC
    };
        
protected:
    BYTE m_bPortNum;
    BYTE m_bBaudRate;
    BYTE m_bDefaultBaudRate;
    BYTE m_bPICClockType;//Because we must set the clock type for pic at the
    					 //beginning.
    BYTE m_bPICCpuType;					 

public :
	int GetCpuType() {
		return ( (int)((char)m_bPICCpuType) );
	}
	
//operation
public:
    virtual BOOL SetSerialOption() = 0;
    virtual BOOL SetSerialPortBaud(BYTE,BYTE) = 0;
    virtual BOOL CommInit() = 0;
    //1996.8 TO TEST THE ABI
    virtual BOOL CommunicationTest(COMTESTERR* pErr) = 0;
    
    virtual BOOL SetPICCpuType(BYTE) = 0;
    virtual BOOL SetPICClockType(BYTE) = 0;
    
    
    BYTE GetSerialPortNum();
    BYTE GetSerialBaudRate();
    BYTE GetPICClockType();
    BYTE GetPICCpuType();
     
 };
 
#endif //serialcm 
 