

/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLBUF.H__   1.13   13 Dec 1996 11:20:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLBUF.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:58   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:12   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:56   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:14   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:06   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:22   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:58   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:22   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:20   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLBUF.H
//
//  Description:The header file for the class: ShellBuffer
//
//  Author:     Roger Zhang
//
//  Date:       03/22/95
//
//  Modification:
//
//      1. 03/22/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLBUF_
#define _SHLBUF_

/////////////////////////////////////////////////////////////////////////////    
const int  MAX_SHELL_LINES = 1000;//4096;  // lines of shell

/////////////////////////////////////////////////////////////////////////////
//  Line of the shell buffer
/////////////////////////////////////////////////////////////////////////////
class ShellBufLine
{
// attributes
public:
    int m_nLength;
    char * m_pchLine;   //  Not end with '\0'    
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBufLine();       
    ShellBufLine(char * pch, int nLen);
    ~ShellBufLine();
                         
// operations                         
public:
    void Shrink(void);
    int operator ! () const { return !m_isOK; }
};

/////////////////////////////////////////////////////////////////////////////
//  Shell Buffer
/////////////////////////////////////////////////////////////////////////////    
class ShellBuffer
{
// attributes
public:
    ShellBufLine * m_LinePtr[MAX_SHELL_LINES];
    int m_nLines;             
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBuffer();
    ~ShellBuffer();                       
                                     
// operations                         
public:
    BOOL AddLine(char * pch, int nLen);
    BOOL AddDispLine(char * pch, int nLen, BOOL isWS = TRUE);
    BOOL OvrDispLine(char * pch, int nLen);
    BOOL AddInputLine(void);
    void Shrink(void) { m_LinePtr[m_nLines - 1]->Shrink(); }
    int operator ! () const { return !m_isOK; }
};

#endif
///////////////////////(EOF)/////////////////////////////////////////////////
