

/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLHIST.H__   1.13   13 Dec 1996 11:20:02   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLHIST.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:02   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:00   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:16   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:32   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:06   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:48   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:22   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:44   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:44   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLHIST.H
//
//  Description:The header file for the class: HistoryList
//
//  Author:     Roger Zhang
//
//  Date:       03/16/95
//
//  Modification:
//
//      1. 03/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLHIST_
#define _SHLHIST_               

/////////////////////////////////////////////////////////////////////////////
//  HistoryElement
/////////////////////////////////////////////////////////////////////////////

class HistoryElement
{
// attributes
public:
    int m_nLength;
    char * m_pchElem;                    
    BOOL m_isOK;
             
// constructor/destructors             
public:
    HistoryElement() : m_nLength(0), m_isOK(TRUE) {}
    HistoryElement(char * pch, int nLen);
    ~HistoryElement();
                          
// operations                          
public:
    int operator ! () const { return !m_isOK; }
};

typedef HistoryElement * PHistoryElement;

/////////////////////////////////////////////////////////////////////////////
//  HistoryList
/////////////////////////////////////////////////////////////////////////////

class HistoryList 
{
// constructor/destructors             
public:
    HistoryList(void);
    ~HistoryList();

// operations                          
public:
    BOOL AddTail(char * pch, int nLen);
    void DelHead(void);
    
    HistoryElement * GetPrev(void);
    HistoryElement * GetNext(void);
    
    BOOL SetMaxSize(int nMax);
    
    int IsEmpty(void) const { return !m_nElem; }
    int IsFull(void) const { return m_nElem == m_nMaxSize; } 
    int IsHead(void) const { return m_nPos == 0; }
    int IsTail(void) const { return m_nPos == m_nElem - 1; }
    
    int operator ! () const { return !m_isOK; }

// attributes
public:
    int m_nMaxSize;           
    int m_nElem;
    int m_nPos;
    PHistoryElement * m_Elem;
    BOOL m_isOK;
    BOOL m_isRecall;
};

#endif
/////////////////////////////(EOF)///////////////////////////////////////////
