
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLSYNCO.H__   1.13   13 Dec 1996 11:20:08   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLSYNCO.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:08   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:06   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:20   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:40   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:06   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:54   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:18:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:36   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:37:02   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:52   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:10:00   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:20:18   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef __SHLSYNCO__H
#define __SHLSYNCO__H             

#include "syntax.h"

typedef struct tagSynColor
{
	CString strText;
	int nColor;
}SynColor;
               
typedef struct tagHintsList
{
	CString strCommand;
	CStringList* plistHints;
	int nCount;
}HintsList;


class CSyntaxCheckSub : public CSyntaxCheck
{
// Construction & Destruction.
public:
    CSyntaxCheckSub();
    ~CSyntaxCheckSub();
    
// Member variables.
private:
    int m_nPos;   //The token number till syntax OK
    int m_nToken; //The total token number
	int m_nEvent;    
    
// Implementations.
private:
    // Syntax check kernel routine.
    BOOL SyntaxCheckRunMacroSub(void);
    BOOL SyntaxCheckVarDefineSub(void);
    BOOL SyntaxCheckAliasSub(void);
    BOOL SyntaxCheckAssembleSub(void);
    BOOL SyntaxCheckBreakpointSub(void);
    BOOL SyntaxCheckByteSub(void);
    BOOL SyntaxCheckChecksumSub(void);
    BOOL SyntaxCheckClearSub(void);
    BOOL SyntaxCheckClockSub(void);
    BOOL SyntaxCheckCompareSub(void);
    BOOL SyntaxCheckControlSub(void);
//    BOOL SyntaxCheckCopySub(void);
    BOOL SyntaxCheckDisassembleSub(void);  
    BOOL SyntaxCheckDiagnosisSub(void);
    BOOL SyntaxCheckEventSub(void);
    BOOL SyntaxCheckEv1Sub(void);
    BOOL SyntaxCheckEv2Sub(void);
    BOOL SyntaxCheckEv3Sub(void);
    BOOL SyntaxCheckFillSub(void);
    BOOL SyntaxCheckGoSub(void);
    BOOL SyntaxCheckHaltSub(void);
    BOOL SyntaxCheckHelpSub(void);
    BOOL SyntaxCheckIdentifySub(void);
    BOOL SyntaxCheckIncludeSub(void);
    BOOL SyntaxCheckInportSub(void);
    BOOL SyntaxCheckJumpSub(void);
    BOOL SyntaxCheckListSub(void);
    BOOL SyntaxCheckLogSub(void);
	BOOL SyntaxCheckMacroSub(void);    
    BOOL SyntaxCheckMdelSub(void);
    BOOL SyntaxCheckMemorySub(void);
    BOOL SyntaxCheckMendSub(void);
    BOOL SyntaxCheckMlistSub(void);
    BOOL SyntaxCheckOutportSub(void);
    BOOL SyntaxCheckQualifySub(void);
    BOOL SyntaxCheckRegisterSub(void);
    BOOL SyntaxCheckResetSub(void);
    BOOL SyntaxCheckSearchSub(void);
    BOOL SyntaxCheckSelectBreakTypeSub(void);    
    BOOL SyntaxCheckStepSub(void);
    BOOL SyntaxCheckTestSub(void);
    BOOL SyntaxCheckTraceSub(void);
    BOOL SyntaxCheckTriggerSub(void);
    BOOL SyntaxCheckUploadSub(void);
    BOOL SyntaxCheckVerifySub(void);
    BOOL SyntaxCheckWordSub(void);
    BOOL SyntaxCheckCreateSub(void);
    BOOL SyntaxCheckDeleteSub(void);
    BOOL SyntaxCheckLoadSub(void);
    BOOL SyntaxCheckQuerySub(void);
    BOOL SyntaxCheckSsaveSub(void);
    BOOL SyntaxCheckSrecallSub(void);
    BOOL SyntaxCheckSymbolSub(void);
    BOOL SyntaxCheckWatchSub(void); 
                                                                           
	void SetSyntaxColorRunMacro(int nPos, int& nArgc, SynColor syncolor[]);                                                                           
	void SetSyntaxColorVarDefine(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAlias(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAssemble(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorBreakpoint(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorByte(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorChecksum(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorClear(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorClock(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCompare(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorControl(int nPos, int& nArgc, SynColor syncolor[]);
//  void SetSyntaxColorCopy(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDisassemble(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDiagnosis(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEvent(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv1(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv2(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv3(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorFill(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorGo(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHalt(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHelp(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorIdentify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInclude(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInport(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorJump(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorList(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLog(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMacro(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMdel(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMemory(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMend(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMlist(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorOutport(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorQualify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorRegister(int nPos, int& nArgc, SynColor syncolor[]);	
	void SetSyntaxColorReset(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSearch(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSelectBreakType(int nPos, int& nArgc, SynColor syncolor[]);	
	void SetSyntaxColorStep(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTest(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrace(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrigger(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorUpload(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorVerify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWord(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCreate(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDelete(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLoad(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorQuery(int nPos, int& nArgc, SynColor syncolor[]);		                                                       
	void SetSyntaxColorSsave(int nPos, int& nArgc, SynColor syncolor[]);			                                                       
	void SetSyntaxColorSrecall(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSymbol(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWatch(int nPos, int& nArgc, SynColor syncolor[]);
	
	void SetSyntaxColorInit(int& nArgc, SynColor syncolor[]);		           
public:
    BOOL CheckCommandSyntaxSub(const char* pchEditBuf, const int nLen, int& nPos);
	BOOL SyntaxDispatchSub(const int nCommandID);	
	BOOL CommandParseSub(void);
	BOOL CheckCommandKeywordSub(void);
	void SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[]);	
	
};

#endif               
