
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCFILE.CPP   1.13   13 Dec 1996 11:20:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCFILE.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:32   ZJRD
** PIC/SLD Version 0.95
** 
**    Rev 1.9   02 Nov 1996 09:49:00   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:51:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:44:28   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.5   09 Oct 1996 13:46:56   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:32   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:54   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:00   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:30   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCFILE.CPP
//
//  Description:The implement file for the class: 
//                  SourceAssemble
//                  SourceMixed
//
//  Author:     Roger Zhang
//
//  Date:       06/20/95
//
//  Modification:
//
//      1. 06/20/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "zqueue.h"
#include "uicom.h"
#include "srccom.h"                  
#include "zlist.h"
#include "srclist.h"
#include "srcmdl.h" 
#include "bwsmdl.h" 
#include "srcfile.h"

/////////////////////////////////////////////////////////////////////////////
extern int SRCDisAsm(unsigned DAsmStartAddr, unsigned DAsmInCodeBlkLen,
                    unsigned *DAsmInstrNum, unsigned *DAsmBytesNum,
                    char     **InstrArray, unsigned *AddrLenArray,
                    char     **LabelArray);

/////////////////////////////////////////////////////////////////////////////
// Disassemble mode class : SourceAssemble
/////////////////////////////////////////////////////////////////////////////
SourceAssemble SrcAsm;
SourceAssemble BwsAsm;
char **g_pText1=NULL, **g_pText2=NULL;                     
unsigned * pAddr=NULL;
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceAssemble::SourceAssemble(void) 
    			: m_nOffset(0), m_nIndex(0), m_lStartAddr(0), m_lRange(0)        
{
    typedef char * PCHAR;
    if(pAddr==NULL)
       pAddr = new unsigned [MAX_RANGE * 2];
       
    if(g_pText1==NULL){
       g_pText1 = new PCHAR[MAX_RANGE * 2];
       for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText1[i] = new char [255])==0);
       }
    }   
    if(g_pText2==NULL){   
       g_pText2 = new PCHAR[MAX_RANGE * 2];
       for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText2[i] = new char [255])==0);
       }
    }   
       
}                         
SourceAssemble::~SourceAssemble()
{           
    int i;
    if(g_pText1){
	    for(i = 0; i < MAX_RANGE * 2; i ++) {
	        delete [] g_pText1[i];
	    }          
    	delete [] g_pText1;
    	g_pText1=NULL;
    }

    if(g_pText2){
	    for(i = 0; i < MAX_RANGE * 2; i ++) {
	        delete [] g_pText2[i];
	    }          
    	delete [] g_pText2;
    	g_pText2=NULL;
    }
    
    if(pAddr){
    	delete [] pAddr;              
    	pAddr=NULL;
    }

    DeleteList();
    
}                         

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SourceAssemble::DeleteList(void)
{

    static AsmLine *pAsm;
    POSITION pos = m_AsmList.GetHeadPosition();
    while(pos) {    
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm){
        pAsm->m_strText.Empty(); 
        delete pAsm;
        }
    }    
    m_AsmList.RemoveAll();
}                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::Dsm(unsigned short uAddr, unsigned short uRange)
{                    
    ASSERT(pAddr);         
    //unsigned * pAddr = new unsigned [MAX_RANGE * 2];
    if(!pAddr)  return  FALSE;
    
    ASSERT(g_pText1);
    ASSERT(g_pText2);
    if(g_pText1==NULL || g_pText2==NULL)
       return FALSE;
/*    
    char ** g_pText1, ** g_pText2;         
    typedef char * PCHAR;
    if((g_pText1 = new PCHAR[MAX_RANGE * 2])==0) return  FALSE;
    if((g_pText2 = new PCHAR[MAX_RANGE * 2])==0) return  FALSE;
    for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText1[i] = new char [255])==0) return FALSE;
        if((g_pText2[i] = new char [255])==0) return FALSE;
    }
*/                                 
    unsigned uBytes;
    unsigned uLines;         
    SRCDisAsm(uAddr, uRange, &uLines, &uBytes, g_pText1, pAddr, g_pText2);
    
    m_lStartAddr = long(uAddr);
    m_lRange = long(uBytes);

    AsmLine * pAsm;             
    
    for(int i = 0; i < int(uLines); i ++) {
        if(g_pText2[i] && strlen(g_pText2[i]) > 0) {
            if((pAsm = new AsmLine) == 0)  goto end;// return FALSE;
            pAsm->m_uAddr   = uAddr;
            pAsm->m_strText = CString("       ") + g_pText2[i];
            pAsm->m_chLabel = 1;
            m_AsmList.AddTail(pAsm);            
        }
        if((pAsm = new AsmLine) == 0)   goto end;//return FALSE;
        pAsm->m_uAddr   = uAddr;
        pAsm->m_strText = g_pText1[i];
        pAsm->m_chLabel = 0;
        uAddr += (unsigned short)(pAddr[i]);
        m_AsmList.AddTail(pAsm);            
    }

 end: 
 /*
    for(i = 0; i < MAX_RANGE * 2; i ++) {
        delete [] g_pText1[i];
        delete [] g_pText2[i];
    }
    delete [] g_pText1;
    delete [] g_pText2;
    delete [] pAddr;              
*/              
    return  TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::Dsm(unsigned short uAddr)
{                                      
    unsigned short uRange = MAX_RANGE;
    if(0x10000L - long(uAddr) < MAX_RANGE)  
        //uRange = (unsigned short)(0x10000L - long(uAddr) + 1);
        uRange = (unsigned short)(0x10000L - long(uAddr));
    
    DeleteList();                    

    if(Dsm(uAddr, uRange) == FALSE) return  FALSE;

    return  TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::CheckAddr(unsigned short uAddr) const
{
    POSITION pos = m_AsmList.GetHeadPosition();
    AsmLine  * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm->m_uAddr == uAddr) return TRUE;
    }                                               
    return FALSE;
}                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::DsmAddr(unsigned short uStart, unsigned short uChk)
{                     
    ASSERT(uChk >= uStart);
    
    for(int i = 0; i < MAX_CHECK; i ++) {
        if(!Dsm(uStart))   return  FALSE;   // out of memory
        if(CheckAddr(uChk)) return  TRUE;   // Ok!
        if(uStart < 0xFFFFU)    ++ uStart;
        else return TRUE;                   // Not Match 
    }                                               
    return  TRUE;                           // Not Match
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
AsmLine * SourceAssemble::GetLine(int nLine) const
{
    AsmLine * p;      
    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    while(pos) {
        p = (AsmLine *)m_AsmList.GetNext(pos);
        if(i++ == nLine)    return p;        
    }
    return  0;
}                          

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::IsHome(void) const
{
    ASSERT(!m_AsmList.IsEmpty());
    
    /*AsmLine * p = (AsmLine *)m_AsmList.GetHead();
    if(!p)  return  FALSE;
    
    return p->m_uAddr < (unsigned short)MAX_CHECK;*/
    return BOOL(m_lStartAddr == 0);
}                            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::IsEnd(void) const
{                        
    ASSERT(!m_AsmList.IsEmpty());
    
    /*AsmLine * p = (AsmLine *)m_AsmList.GetTail();
    if(!p)  return  FALSE;
    
    return 0x10000L - long(p->m_uAddr) <= long(MAX_CHECK);*/
    return BOOL(m_lStartAddr + m_lRange >= 0x10000L);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::DsmPrev(void)
{
    ASSERT(!IsHome());
    ASSERT(!m_AsmList.IsEmpty());
    
    AsmLine * p = (AsmLine *)m_AsmList.GetHead();
    if(!p)  return  FALSE;
    
    unsigned short uNew = (p->m_uAddr >= (unsigned short)MAX_PAGE) ? 
        p->m_uAddr - MAX_PAGE : 0;
    return DsmAddr(uNew, p->m_uAddr);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::DsmNext(void)
{
    ASSERT(!IsEnd());
    ASSERT(!m_AsmList.IsEmpty());
    
    AsmLine * p1 = (AsmLine *)m_AsmList.GetHead();
    if(!p1)  return  FALSE;
    AsmLine * p2 = (AsmLine *)m_AsmList.GetTail();
    if(!p2)  return  FALSE;
    
    long lNew = long(p1->m_uAddr) + long(MAX_PAGE);
    if(lNew > 0xFFFFL)   lNew = long(p1->m_uAddr); 
    if((unsigned short)lNew<=p2->m_uAddr)
        return DsmAddr((unsigned short)lNew, p2->m_uAddr);
    return 1;    
}                                          

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceAssemble::Addr2Line(long lAddr) const
{                                 
    if(lAddr > 0xFFFFL)  return m_AsmList.GetCount();
    
    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm->m_uAddr == (unsigned short)lAddr && !(pAsm->m_chLabel)) 
            return  i;        
        else    ++ i;
    }                
    return  i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceAssemble::Addr2LineL(long lAddr) const
{                                 
    if(lAddr > 0xFFFFL)  return m_AsmList.GetCount();
    
    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm->m_uAddr == (unsigned short)lAddr) 
            return  i;        
        else    ++ i;
    }                
    return  i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceAssemble::MatchAddr2Line(long lAddr) const
{
    if(lAddr > 0xFFFFL) return m_AsmList.GetCount();
    
    POSITION pos = m_AsmList.GetHeadPosition();
    AsmLine * pAsm;             
    int i = 0;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm->m_uAddr >= (unsigned short)lAddr && !(pAsm->m_chLabel)) 
            return  i;
        else ++ i;
    }                
    return  i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceAssemble::MatchAddr2LineL(long lAddr) const
{
    if(lAddr > 0xFFFFL) return m_AsmList.GetCount();
    
    POSITION pos = m_AsmList.GetHeadPosition();
    AsmLine * pAsm;             
    int i = 0;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm->m_uAddr >= (unsigned short)lAddr) 
            return  i;
        else ++ i;
    }                
    return  i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
long SourceAssemble::Line2Addr(int nLine) const
{                      
    ASSERT(nLine >= 0);
    
    if(nLine >= m_AsmList.GetCount())   return 0x10000L;

    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(i == nLine && !(pAsm->m_chLabel)) return  pAsm->m_uAddr;        
        else    ++ i;
    }                
    return  0x10000L;
}            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
long SourceAssemble::Line2AddrL(int nLine) const
{                      
    ASSERT(nLine >= 0);
    
    if(nLine >= m_AsmList.GetCount())   return 0x10000L;

    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(i == nLine) return  pAsm->m_uAddr;        
        else    ++ i;
    }                
    return  0x10000L;
}            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceAssemble::IsLabelLine(int nLine)
{
    ASSERT(nLine >= 0);
    
    if(nLine >= m_AsmList.GetCount())   return TRUE;

    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(i == nLine) {
            if(pAsm->m_chLabel) return TRUE;
            else return  FALSE;        
        } else    ++ i;
    }                
    return  FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Mixed Mode Class : SourceMixed
/////////////////////////////////////////////////////////////////////////////
SourceMixed SrcMix(0);                
SourceMixed BwsMix(1);


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
 SourceMixed::SourceMixed(BOOL bBrowse)
 {
 	m_bBrowse=bBrowse;
    typedef char * PCHAR;
    if(pAddr==NULL)
       pAddr = new unsigned [MAX_RANGE * 2];
       
    if(g_pText1==NULL){
       g_pText1 = new PCHAR[MAX_RANGE * 2];
       for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText1[i] = new char [255])==0);
       }
    }   
    if(g_pText2==NULL){   
       g_pText2 = new PCHAR[MAX_RANGE * 2];
       for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText2[i] = new char [255])==0);
       }
    }   
 	
 };            
 SourceMixed::~SourceMixed()
{
    int i;
    if(g_pText1){
	    for(i = 0; i < MAX_RANGE * 2; i ++) {
	        delete [] g_pText1[i];
	    }          
    	delete [] g_pText1;
    	g_pText1=NULL;
    }

    if(g_pText2){
	    for(i = 0; i < MAX_RANGE * 2; i ++) {
	        delete [] g_pText2[i];
	    }          
    	delete [] g_pText2;
    	g_pText2=NULL;
    }
    
    if(pAddr){
    	delete [] pAddr;              
    	pAddr=NULL;
    }
    DeleteList();
}

#ifdef _DEBUG
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SourceMixed::DumpFile(const char * pszFileName) const
{
    FILE * fp = fopen(pszFileName, "wt");
    if(fp == NULL)  return;
    
    fprintf(fp, "m_nSrcStart = %d\n", m_nSrcStart);
    fprintf(fp, "m_nSrcLines = %d\n", m_nSrcLines);
        
    fprintf(fp, "m_nAsmPos:\n");        
    for(int i = 0; i < m_nSrcLines; i ++)
        fprintf(fp, "%d --> %d\n", i, m_nAsmPos[i]);
        
    fprintf(fp, "m_AsmList:\n");        

    POSITION pos = m_AsmList.GetHeadPosition();
    AsmLine * pAsm;
    i = 0;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);            
        fprintf(fp, "%d -->", i++);
        fprintf(fp, "%s\n", (const char *)(pAsm->m_strText));
    }                                 

    fclose(fp);
} 

#endif            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SourceMixed::DeleteList(void)
{                   
     
    static AsmLine *pAsm;
    POSITION pos = m_AsmList.GetHeadPosition();
    while(pos) {    
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(pAsm){
        pAsm->m_strText.Empty(); 
        delete pAsm;
        }
    }                                 
    m_AsmList.RemoveAll();
}                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::GetLineAddr(int nLine, unsigned short &uAddr, 
    unsigned short &uRange)
{                                 
    int nSrcLines=(m_bBrowse?BWSSRCLINES:SRCLINES);
    
    ASSERT(nLine >= 0 && nLine <= nSrcLines);
    
    if(nLine == nSrcLines)   return FALSE;
    
    unsigned long dwStart, dwEnd;
    unsigned long dwModule=(m_bBrowse?bwsMdlInfo.CurModule():MdlInfo.CurModule());
    
    if(SrcLinenum2Range(dwModule, (unsigned short)(nLine + 1), dwStart, dwEnd) == -1)    
        return FALSE;
        
    uAddr = (unsigned short)dwStart;
    uRange = (unsigned short)(dwEnd - dwStart + 1);               

    return  TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Disassemble address range
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::Dsm(unsigned short uAddr, unsigned short uRange)
{   
  /*
    if(uRange>MAX_RANGE){                          
       AfxMessageBox("Range Error!");
    }   
    unsigned * pAddr = new unsigned [MAX_RANGE * 2];
    if(!pAddr)  return  FALSE;
    char ** g_pText1, ** g_pText2;         
    typedef char * PCHAR;
    if((g_pText1 = new PCHAR[MAX_RANGE * 2])==0) return  FALSE;
    if((g_pText2 = new PCHAR[MAX_RANGE * 2])==0) return  FALSE;
    for(int i = 0; i < MAX_RANGE * 2; i ++) {
        if((g_pText1[i] = new char [255])==0) return FALSE;
        if((g_pText2[i] = new char [255])==0) return FALSE;
    }
    */                             
    unsigned uBytes;
    unsigned uLines;
    SRCDisAsm(uAddr, uRange, &uLines, &uBytes, g_pText1, pAddr, g_pText2);

    AsmLine * pAsm;             
    
    for(int i = 0; i < int(uLines); i ++) {
        if(g_pText2[i] && strlen(g_pText2[i]) > 0) {
            if((pAsm = new AsmLine) == 0)   return FALSE;
            pAsm->m_uAddr   = uAddr;
            pAsm->m_strText = CString("       ") + g_pText2[i];
            pAsm->m_chLabel = 1;
            m_AsmList.AddTail(pAsm);            
        }
        if((pAsm = new AsmLine) == 0)   return FALSE;
        pAsm->m_uAddr   = uAddr;
        pAsm->m_strText = g_pText1[i];
        pAsm->m_chLabel = 0;
        uAddr += (unsigned short)(pAddr[i]);
        m_AsmList.AddTail(pAsm);            
    }
/*
    for(i = 0; i < MAX_RANGE * 2; i ++) {
        delete [] g_pText1[i];
        delete [] g_pText2[i];
    }
    delete [] g_pText1;
    delete [] g_pText2;
    delete [] pAddr;              
*/              
    return  TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::DsmLine(int nLine)
{                        
    unsigned short uAddr, uRange;    
    if(!GetLineAddr(nLine, uAddr, uRange))  // no code
        m_nAsmPos[nLine - m_nSrcStart] = -1;
    else {
        m_nAsmPos[nLine - m_nSrcStart] = m_AsmList.GetCount();
        while(uRange > MAX_RANGE) {
            if(!Dsm(uAddr,100))/* MAX_RANGE))*/  return FALSE;
            else {
                uAddr += 100;//MAX_RANGE;
                uRange -= 100;//MAX_RANGE;
            }            
        }
        if(uRange > 0) {
            if(!Dsm(uAddr, uRange))  return FALSE;
        } 
    }    
    return TRUE;
}               

BOOL SourceMixed::DsmLine(int nLine, int nCount,int nSrcLines)
{                        
    unsigned short uAddr, uCAddr,uRange, nTotalRange;    
    int  nCursor=nLine;
    uCAddr=0;
/*    
    while(!GetLineAddr(nCursor, uAddr, nTotalRange))
    {   
        nCursor++;
    	m_nAsmPos[nCursor - m_nSrcStart] = -1;
    }
    uCAddr=uAddr;
*/    
    for(nTotalRange=0; nCursor<nLine+nCount && nCursor<nSrcLines; nCursor++ )
    { 
        if(!GetLineAddr(nCursor, uAddr, uRange)){
           if(nTotalRange>0){
		        while(nTotalRange>MAX_RANGE) {
		            if(!Dsm(uCAddr,100))/* MAX_RANGE))*/  return FALSE;
		            else {
		                uAddr 		+= 100;//MAX_RANGE;
		                nTotalRange -= 100;//MAX_RANGE;
		            }            
		        }
		        if(nTotalRange > 0) {
		            if(!Dsm(uCAddr, nTotalRange))  return FALSE;
		        } 
           
           }
           nTotalRange=0;
           uCAddr=uAddr;                                                           
           m_nAsmPos[nCursor - m_nSrcStart] = -1;
        }else if(uAddr!=(uCAddr+nTotalRange)){
           if(nTotalRange>0){
		        while(nTotalRange>MAX_RANGE) {
		            if(!Dsm(uAddr,100))/* MAX_RANGE))*/  return FALSE;
		            else {
		                uAddr 		+= 100;//MAX_RANGE;
		                nTotalRange -= 100;//MAX_RANGE;
		            }            
		        }
		        if(nTotalRange > 0) {
		            if(!Dsm(uAddr, nTotalRange))  return FALSE;
		        } 
           
           }
           nTotalRange=uRange;
           uCAddr=uAddr;
           m_nAsmPos[nLine - m_nSrcStart] = m_AsmList.GetCount();
        }else{
          nTotalRange+=uRange;
          m_nAsmPos[nLine - m_nSrcStart] = m_AsmList.GetCount()+nTotalRange;
        }   
    }
                         
    if(nTotalRange>0){
	   while(nTotalRange>MAX_RANGE) {
	         if(!Dsm(uAddr,100))/* MAX_RANGE))*/  return FALSE;
	          else {
	                uAddr 		+= 100;//MAX_RANGE;
	                nTotalRange -= 100;//MAX_RANGE;
		            }            
	   }
	   if(nTotalRange > 0) {
	      if(!Dsm(uAddr, nTotalRange))  return FALSE;
	   } 
     }

    return TRUE;
}               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::Dsm(int nLine)
{                                         
    int nSrcLines=(m_bBrowse?BWSSRCLINES:SRCLINES);

    ASSERT(nLine >= 0 && nLine <= nSrcLines);
    
    if(nLine == nSrcLines)  return  FALSE;          
    
    DeleteList();
    m_nSrcStart = nLine;
    m_nSrcLines = 0;
        
	int n;        
    if(!DsmLine(nLine)) return FALSE;       
    else {
        ++ m_nSrcLines; ++ nLine;
    	n = m_AsmList.GetCount() + m_nSrcLines;
        if(nLine == nSrcLines)    return TRUE;
    }
#undef  _ASM_TIMER    
 #ifdef _ASM_TIMER
 CString str;
 DWORD dwTime=GetTickCount();
 #endif
 /*
    if(!DsmLine(nLine,(MIN_LINES-m_nSrcLines+n),nSrcLines))
       return FALSE;
*/
    unsigned short uTotalRange=0,uRange=0,uAddr=0;
    for(int nLines=nLine;
    	uTotalRange<60 && nLines<MIN_LINES && nLines <= nSrcLines;
    	nLines++)
    {
    	if(GetLineAddr(nLines, uAddr, uRange))
    	  uTotalRange+=(uRange);
    	else
    	  nLines=MIN_LINES;
    	  
    }             

    nLines=(nLines-nLine+1)>MIN_LINES?80:(nLines-nLine+1);
/*    
    if(nLines<20)
       nLines=MIN_LINES;
*/
    while(m_AsmList.GetCount() + m_nSrcLines - n < MIN_LINES) {
         DsmLine(nLine);
         ++ m_nSrcLines; ++ nLine;
         if(nLine >= nSrcLines)    break;
/*       

        if(!DsmLine(nLine)) continue;//return FALSE;
        else 
        {
            ++ m_nSrcLines; ++ nLine;
            if(nLine == nSrcLines)    break;
        }
*/        
    } 
 
 #ifdef _ASM_TIMER
 str.Format("time:%d\nlines %d",int(GetTickCount()-dwTime),int(nLines));
 AfxMessageBox(str);
 #endif
                                          
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
AsmLine * SourceMixed::GetLine(int nSrcLine, int nAsmLine) const
{                                               
    int nSrcLines=(m_bBrowse?BWSSRCLINES:SRCLINES);
    ASSERT(nSrcLine >= 0 && nSrcLine <= nSrcLines);
    ASSERT(nAsmLine >= -1);

    if(nSrcLine == nSrcLines || nAsmLine == -1)    return  0;
    if(nSrcLine < m_nSrcStart || nSrcLine >= m_nSrcStart + m_nSrcLines)
        return  0;
    
    int nPos = m_nAsmPos[nSrcLine - m_nSrcStart];
    if(nPos == -1)  return  0;
    
    POSITION pos = m_AsmList.GetHeadPosition();
    int i = 0;
    int j = 0;
    AsmLine * pAsm;
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);       
        if(i == nPos) {
            if(j == nAsmLine)   return  pAsm;
            else    ++ j;
        } else  ++ i;
    }                
    return  0;
}   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::IsHome(void) const
{
    return  m_nSrcStart == 0;
}                          

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::IsEnd(void) const
{
    return  m_nSrcStart + m_nSrcLines >= (m_bBrowse?BWSSRCLINES:SRCLINES);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::DsmPrev(void)
{
    ASSERT(!IsHome());
     
    unsigned short uAddr, uRange;
     
    for(int i = 0, nLine = m_nSrcStart - 1; i < MAX_PAGELINE; ++ i, -- nLine) {
        if(GetLineAddr(nLine, uAddr, uRange))   break;
        else if(nLine == 0) break;            
    }
    
    return  Dsm(nLine);    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceMixed::DsmNext(void)
{                   
    ASSERT(!IsEnd());

    int nLine = m_nSrcStart + m_nSrcLines - 1;
    return  Dsm(nLine);    
}                                
                                     
// nLine is the offset to m_nSrcStart, also return offset                                     
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceMixed::GetNextAsmLine(int nLine) const
{
    ASSERT(nLine >= 0 && nLine < m_nSrcLines);
    
    while(++nLine < m_nSrcLines) {                  
        if(m_nAsmPos[nLine] != -1)  return nLine;
    }
    return  -1;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceMixed::GetAsmLines(int nLine) const
{                                          
    int nSrcLines=m_bBrowse?BWSSRCLINES:SRCLINES;
    ASSERT(nLine >= 0 && nLine <= nSrcLines);
    
    if(nLine == nSrcLines)  return  0;
    if(nLine < m_nSrcStart || nLine >= m_nSrcStart + m_nSrcLines)
        return  0;
        
    int nOfs = nLine - m_nSrcStart;
    if(m_nAsmPos[nOfs] == -1)   // no asm line
        return  0;
    else {                                             
        int i = GetNextAsmLine(nOfs);
        if(i == -1)
            return  m_AsmList.GetCount() - m_nAsmPos[nOfs];
        else
            return  m_nAsmPos[i] - m_nAsmPos[nOfs];
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceMixed::Line2Ofs(int nSrc, int nAsm) const
{                                       
    int nSrcLines=m_bBrowse?BWSSRCLINES:SRCLINES;
    ASSERT(nAsm >= -1); 
    ASSERT(nSrc >= 0 && nSrc <= nSrcLines);
    
    if(nSrc == nSrcLines)    
        return  m_nSrcLines + m_AsmList.GetCount() + nAsm + 1;
                         
    int k = 0;
    for(int i = 0; i < nSrc - m_nSrcStart; i ++) 
        k += GetAsmLines(i + m_nSrcStart) + 1;
    return k + nAsm + 1;
}                           
                              
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceMixed::Ofs2Line(int nOfs, int &nAsm) const
{
    ASSERT(nOfs >= 0);
    int nSrcLines=(m_bBrowse?BWSSRCLINES:SRCLINES);
    
    nAsm = nOfs;
    int n = m_nSrcStart;
    int k = (m_bBrowse?(BwsMix.GetAsmLines(n)+1):(SrcMix.GetAsmLines(n) + 1));
    while(nAsm >= k) {
        nAsm -= k;        
        ++ n;
        if(n < nSrcLines) k = (m_bBrowse?(BwsMix.GetAsmLines(n)+1):(SrcMix.GetAsmLines(n)+ 1));
    }                                          
    -- nAsm;                      
    return  n;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceMixed::Addr2Ofs(unsigned short uAddr) const
{
    POSITION pos = m_AsmList.GetHeadPosition();
    AsmLine * pAsm;
    int i = 0, j = -1, k;                                            
    while(pos) {
        pAsm = (AsmLine *)m_AsmList.GetNext(pos);
        if(uAddr == pAsm->m_uAddr && pAsm->m_chLabel == 0) {
            j = i;  break;
        } else ++ i;
    }               
    
    if(j == -1) return m_bBrowse?BWSMIXLINES:MIXLINES;
    
    for(i = 0, k = -1; i < m_nSrcLines && m_nAsmPos[i] <= j; i ++) {
        if(m_nAsmPos[i] == -1)  continue;
        else    k = i;            
    }           
    if(k == -1) return m_bBrowse?BWSMIXLINES:MIXLINES;
    else return  j + k + 1;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SrcCleanAsm(void)
{
    SrcAsm.DeleteList();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SrcCleanMix(void)
{
    SrcMix.DeleteList();
}


//////////////////////////////(EOF)//////////////////////////////////////////
