
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCLIST.H__   1.13   13 Dec 1996 11:20:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCLIST.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:22   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:20   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:34   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:24   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:40   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:18   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:02   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:18   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:14   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:56   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCLIST.H
//
//  Description:The header file for the class: 
//                  SyntaxColorList
//                  TabExpandList
//                  SourceIndexList
//                  SourceList
//
//  Author:     Roger Zhang
//
//  Date:       06/10/95
//
//  Modification:
//
//      1. 06/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCLIST_
#define _SRCLIST_

/////////////////////////////////////////////////////////////////////////////
//  Syntax color list 
/////////////////////////////////////////////////////////////////////////////
class SyntaxColorElement : public SListElement
{
public:                        
    int m_nFirstCol, m_nLastCol;
    int m_nSyntaxType; 
    
    SyntaxColorElement(int nFirst, int nLast, int nType)
    : m_nFirstCol(nFirst), m_nLastCol(nLast), m_nSyntaxType(nType)
    {}   
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                     
                     
class SyntaxColorList : public SingleList                
{
public:                                     
    SyntaxColorList(void) : SingleList() {}
    int AddElement(int nFirst, int nLast, int nType);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};

/////////////////////////////////////////////////////////////////////////////
// Tab expand list 
/////////////////////////////////////////////////////////////////////////////           
class TabExpandElement : public SListElement
{
public:
    int m_nTabPos, m_nTabAdd;
    
    TabExpandElement(int nPos, int nAdd)
    : m_nTabPos(nPos), m_nTabAdd(nAdd)
    {}
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                                

class TabExpandList : public SingleList
{
public:                                             
    TabExpandList(void) : SingleList() {}
    int AddElement(int nPos, int nAdd);
    int Search(int nPos) const;
    int Expand(int nPos) const;
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};
                                                         
///////////////////////////////////////////////////////////////////////////// 
// Index list 
/////////////////////////////////////////////////////////////////////////////
class SourceIndexElement : public SListElement 
{
public:                                
    SListNode * m_pSrc;    
    int m_nIdx;
    SourceIndexElement(SListNode * pSrc, int nIdx)
    : m_pSrc(pSrc), m_nIdx(nIdx)
    {}
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                 

class SourceIndexList : public SingleList
{
public:
    enum { INDEX_DELTA = 32 };
    
    SourceIndexList(void) : SingleList() {}
    int AddElement(SListNode * pSrc, int nIdx);
    SourceIndexElement * Search(int nIdx);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                                        
                                                         
///////////////////////////////////////////////////////////////////////////// 
// Source file list 
/////////////////////////////////////////////////////////////////////////////                 
class SourceElement : public SListElement
{
public:
    SyntaxColorList m_Color;
    TabExpandList   m_Tab;
    char    * m_szLine;
    int     m_nLength;      
             
    SourceElement(void)
    : m_szLine(0), m_nLength(0)
    {}                                    
    virtual ~SourceElement(void); 
    int ExpandTab(int nPos) const { return m_Tab.Expand(nPos); }
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};

class SourceList : public SingleList
{
public:
    enum { MAX_LINELEN = 511, MAX_LINES = 32000 };
    
    SourceList(void) : SingleList(MAX_LINES) {}
    SourceElement * Search(SListNode * pIdx, int nDelta);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};
                                           


#endif
/////////////////////////(EOF)///////////////////////////////////////////////
