
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCMDL.H__   1.13   13 Dec 1996 11:20:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCMDL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:22   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:22   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:38   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:36   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:24   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:42   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:18   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:02   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:08   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:18   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:14   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:56   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCMDL.H
//
//  Description:The header file for the class: 
//                  SourceModule
//                  ModuleInfo
//
//  Author:     Roger Zhang
//
//  Date:       06/26/95
//
//  Modification:
//
//      1. 06/26/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCMDL_
#define _SRCMDL_

/////////////////////////////////////////////////////////////////////////////
// SourceModule
/////////////////////////////////////////////////////////////////////////////
class SourceModule 
{
public:                       
    enum { ERR_OK, ERR_FAIL, ERR_LINETOOLONG, ERR_TOOMANYLINE,	// used by loader
        ERR_READFAIL, ERR_OPENFAIL, ERR_EOL, ERR_EOF, ERR_MEM };
    enum { MAX_KEYWORD = 9 };

    SourceList      m_Src;
    SourceIndexList m_Idx;
    CString    m_strFileName;                       

private:    
    enum { FG_NORMAL, FG_COMMENT };	// used on parsing

    SourceElement * m_pLineInfo;    
    char          * m_szBuf;        // buffer to hold a line
    char          * m_szTab;        // buffer to hold the line after 
    								// tab expand
    char            m_szToken[MAX_KEYWORD + 1];
    FILE          * m_Fp;           // file pointer
    int             m_nFirst;       // used on parsing            
    int             m_nCur;         // used on parsing
    int             m_nLine;
    int             m_nEof;
    int             m_nFlag;		// flag used on parsing
	BOOL			m_isAsmLine;
	    
public:    
    SourceModule(void);
    ~SourceModule(void); 
    
    void Clean(void) {
        m_Src.Clean();  m_Idx.Clean();
    }
    
    int Load(const char * pszFileName);
    int Reload(void);
    
    SourceElement * GetLine(int nIdx);
    BOOL SearchAfter(int nLine, int nCol, int nEndLine); 
    BOOL SearchBefore(int nLine, int nCol, int nEndLine);

private:    
    int IsDelimit(char ch) const;
    int SearchKeyword(const char * p) const;
    int ReadLine(void);    
    int ExpandTab(void);
    int ScanString(void);
    int ScanChar(void);
    int ScanCComment(void);
    int ScanCPPComment(void);
    int ScanToken(void);
    int ScanCode(void);
    int ScanDelimit(void);
    int ParseColor(void);
    int ParseLine(void);
	BOOL IsAsmFile(const char * pszFileName) const;
	int SearchString(const char * str1, const char * str2, int nFlag) const;
	int SearchLine(const char * str1, const char * str2, int nCol, 
			int nFlag, BOOL isUp) const;
};

/////////////////////////////////////////////////////////////////////////////
// ModuleInfo
/////////////////////////////////////////////////////////////////////////////
class ModuleInfo
{
public:       
    enum { MAX_MODULE = 5 }; 
    
    SourceModule m_Module[MAX_MODULE];
    int          m_nModuleLoaded[MAX_MODULE];
    int          m_nModuleIdx;       
    unsigned      * m_pModuleValue;
    unsigned long * m_pModule;
    unsigned short m_uModules;
    
    ModuleInfo(void);
    ~ModuleInfo();         
    
    BOOL Init(void);
    BOOL IsModuleOn(void) { return m_nModuleIdx != -1; }
    unsigned long CurModule(void) const;
    int LoadModuleIdx(unsigned long dwModuleIdx);
    int LoadPCModule(void);
    int Reload(void);
    
private:    
    void Clean(void);
    
    CString MakeModulePath(unsigned long dwModuleIdx) const;
    BOOL CleanOldModule(void);
};

extern ModuleInfo MdlInfo;

int SrcReadLine(void);
int SrcOpenFile(DWORD dwModule);

#endif
//////////////////////////////(EOF)//////////////////////////////////////////

