 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMADD.H__   1.13   13 Dec 1996 11:20:34   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMADD.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:34   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:34   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:50   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:48   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:36   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:38   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:12   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:14   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:43:58   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:22   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:06   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:32   ZJRD
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symadd.h
**
**  Description:
**     Prototypes for the functions to add to the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/SYMADD.H__   1.13   13 Dec 1996 11:20:34   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMADD_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "memmanag.h"
#include "symmgr.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
//------------------------------------------------------------------------
// Symbol Server INI setting definitions
#define SAPP_NAME "SymbolInfo"
#define SAPP_LABEL "ConvertLabelsToRanges"

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/***************************************************************************
** InitSymTable
**
** Description: Initializes the symbol table.
**
** Input Parameters:
**    none:
** Output Parameters:
**    none:
** Errors:
**    ER_OUT_OF_MEMORY:
** NOTE: no BaseSymbol is created on initialization.  This means that any
**    loader must first create a base (and its index) before using it.
***************************************************************************/
RETCODE InitSymTable(VOID);

//--------------------------------------------------------------------------
// SymAddGetModuleName
//--------------------------------------------------------------------------
RETCODE SymAddGetModuleName(SYM_DESCRIPTOR module, LPSTR modName);

/****************************************************************************
**
**  SymInitSymServer
**
**  Description:
**     Initializes the symbol server
**     
**  Parameters:
**     input:
**        cliHandle:  the handle of the cli server
**        dllHandle:  the handle of the symbol server
**     output:
**        none:
**        (returns): error code
**
*****************************************************************************/
RETCODE SymInitSymServer(HANDLE cliHandle,HANDLE dllHandle);


#define _SYMADD_
#endif
/******************************** E O F ***********************************/
