 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMBLEXT.CPP   1.13   13 Dec 1996 11:20:36   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMBLEXT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:36   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:34   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:50   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:50   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:48   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:10   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:58   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:12   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:32   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:16   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:26   ZJRD
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symblext.cpp
**
**  Description:
**     Contains Symbol Extended function definitions which handle bulk-data
**     access. 
**
**  Status: PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/SYMBLEXT.CPP   1.13   13 Dec 1996 11:20:36   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "symblsvr.h"                      
#include "symblext.h"
#include "linenum.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//----------------------------------------------------------------------------
// Symbol Tables
extern MemPool st;       //
extern LinenumTable lt;  // defined in LINENUM.CPP
extern TABLE_OFFSET rootOffset;

//----------------------------------------------------------------------------
// Symbol Statistics 
extern U32 symbolStat[]; // defined in SYMADD.CPP

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
//-----------------------------------------------------------------------------
// SymGetSymStats
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetSymStats(U16 FAR* numModules, U32 FAR* numFunctions, U32 FAR*
               numPublicLabels, U32 FAR* numUserLabels) {
   *numModules      = (U16)symbolStat[SYM_MODULE];
   *numFunctions    = symbolStat[SYM_FUNCTION];
   *numPublicLabels = symbolStat[SYM_PUBLIC_LABEL];
   *numUserLabels   = symbolStat[SYM_USER_DEFINED_LABEL];
   return GOOD;
}


//-----------------------------------------------------------------------------
// SymGetSiblingSymbols
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetSiblingSymbols(SYM_DESCRIPTOR      symDesc,
                     SYM_TYPE_TYPE       basicSymType,
                     U16                 numRequested,
                     SYM_DESCRIPTOR FAR* symDescArray,
                     U16 FAR*            numReturned) {

   SYM_DESCRIPTOR headDesc = symDesc;
   HPU8 ptr;

   // Check for valid symbol type currently support by this routine
   if (!((basicSymType == SYM_MODULE) ||
         ((basicSymType == SYM_FUNCTION) && (symDesc != NULL_SYMBOL)) ||
         (basicSymType == SYM_PUBLIC_LABEL) ||
         (basicSymType == SYM_USER_DEFINED_LABEL)))
      return ER_INVALID_SYM_DESCRIPTOR;

   // Process each type of symbol
   switch(basicSymType) {
      case SYM_MODULE :
         // Get the list of modules from it head list
         RETCODE err;
         if ((symDesc == NULL_SYMBOL) &&
             ((err = SymGetModuleListHead(&headDesc)) != GOOD))
            return err;
         break;

      case SYM_PUBLIC_LABEL :
      case SYM_USER_DEFINED_LABEL:
         if (symDesc == NULL_SYMBOL) {
            ptr = st.GetHugeDataPtr(rootOffset);
            headDesc = ((COMMON_BLOCK_HEADER *)ptr)->list.labelListOffset;
         }
         break;
   }

   // make sure the headDesc is ok
   if (!UtilIsValidSymDescriptor(headDesc))
      return ER_INVALID_SYM_DESCRIPTOR;

   ptr = st.GetHugeDataPtr(headDesc);
   *numReturned = 0;

   // whether the numReturned count is excluding the input symbol
   // only count if the symDesc == NULL_SYMBOL
   if (symDesc == NULL_SYMBOL) {
     symDescArray[(*numReturned)] = headDesc;
     ++(*numReturned);
   }
    
   // Retrieve the list of siblings from the headDesc
   SYM_DESCRIPTOR nextSym;
   while (((nextSym = ((COMMON_BLOCK_HEADER *)ptr)->symHeader.symSiblingOffset)
          != NULL_SYMBOL) && ((*numReturned) < numRequested)) {
      symDescArray[(*numReturned)] = nextSym;
      ++(*numReturned);
      ptr = st.GetHugeDataPtr(nextSym);
   }        
   return GOOD;      
}

//-----------------------------------------------------------------------------
// SymGetChildSymbolsOfModule
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetChildSymbolsOfModule(SYM_DESCRIPTOR      moduleDesc,
                           SYM_TYPE_TYPE       basicSymType,
                           U16                 numRequested,
                           SYM_DESCRIPTOR FAR* symDescArray,
                           U16 FAR*            numReturned) {
   RETCODE err;
   SYM_TYPE_TYPE  childType;
   SYM_DESCRIPTOR childDesc, nextChild;

   *numReturned = 0;
   // retrieve the first child <basicSymType> of the <moduleDesc> 
   if ((err = SymGetSymbolChild(moduleDesc, &childType, &childDesc)) != GOOD)
      return err;

   // return error if there is no child in <moduleDesc>
   if (childDesc == NULL_SYMBOL)
      return ER_SYMBOL_NOT_FOUND;

   // traverse the child list until we get the head of <basicSymType>
   while ((childType != basicSymType) && (childDesc != NULL_SYMBOL)) {
      if ((err = SymGetSymbolSibling(childDesc, &childType, &nextChild))
          != GOOD)
         return err;
      childDesc = nextChild;
   }

   // return error if childType is not what we are looking for
   if ((childDesc == NULL_SYMBOL) || (childType != basicSymType))
      return ER_SYMBOL_NOT_FOUND;

   // Save the first child descriptor to list
   symDescArray[0] = childDesc;
   ++(numReturned);

   // call to retrieve the rest of the requested list - increment the array
   U16 count;
   if ((err = SymGetSiblingSymbols(childDesc, basicSymType, numRequested-1,
           (symDescArray+1), &count)) != GOOD)
      return err;

   // update the numReturned with the count
   (*numReturned) += count;

   return GOOD;
}


//-----------------------------------------------------------------------------
// SymGetLineNumbersOfModule
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetLineNumbersOfModule(SYM_DESCRIPTOR          moduleDesc,
                          U16                     numRequested,
                          LINENUM_DESCRIPTOR FAR* lineDescArray,
                          U16 FAR*                numReturned) {

   RETCODE err;
   LINENUM_DESCRIPTOR firstIndex;
   
   *numReturned = 0;
   // test for valid module desc 
   if (!UtilIsValidSymDescriptor(moduleDesc))
      return ER_ADDRESS_NOT_FOUND;

   // Get the first line number index of <moduleDesc>
   if ((err = SymGetLinenumFirstIndex(moduleDesc, &firstIndex)) != GOOD)
      return err;

   // Save the first index and get the rest
   lineDescArray[0] = firstIndex;
   ++(*numReturned);

   // retrieve the rest of the numRequested line indexes
   U16 count;
   if ((err = SymGetLineNumbersList(moduleDesc, firstIndex, numRequested-1,
          (lineDescArray+1), &count)) != GOOD)
      return err;

   // update the numReturned with the count
   (*numReturned) += count;

   return GOOD;
}

//-----------------------------------------------------------------------------
// SymGetLineNumbersList
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetLineNumbersList(SYM_DESCRIPTOR          moduleDesc,
                      LINENUM_DESCRIPTOR      startLineDesc,
                      U16                     numRequested,
                      LINENUM_DESCRIPTOR FAR* lineDescArray,
                      U16 FAR*                numReturned) {

   // call the LinenumTable::GetLineNumbersList() to do the work
   return lt.GetLineNumbersList(moduleDesc,
                                startLineDesc,
                                numRequested,
                                lineDescArray,
                                numReturned);
} 

/********************************** E O F ***********************************/
