
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMBLEXT.H__   1.13   13 Dec 1996 11:20:36   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMBLEXT.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:36   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:36   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:50   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:50   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:54   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:16   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:04   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:48   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:56   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:26   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:34   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symblext.h
**
**  Description:
**     Contains declarations of external interfaces to handle bulk-data
**     access from the Symbol server.
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/SYMBLEXT.H__   1.13   13 Dec 1996 11:20:36   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMBLEXT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symblsvr.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*****************************************************************************
** SymGetSymStats
**
** Purpose:
**    Retrieve the number of modules, functions, labels loaded.
**
** Input parameter:
**    none
** Output parameters:
**    numModules:      pointer to number of modules loaded
**    numFunctions:    pointer to number of functions loaded
**    numPublicLabels: pointer to number of public labels loaded
**    numUserLabels:   pointer to number of user-defined labels.
**
** Error:
**    Reports error if no symbol loaded
**
*****************************************************************************/
RETCODE EXPORT 
SymGetSymStats(U16 FAR* numModules, U32 FAR* numFunctions, U32 FAR*
               numPublicLabels, U32 FAR* numUserLabels); 


/***************************************************************************
** SymGetSiblingSymbols
**
** Purpose:
**    Get the specified number of sibling symbol descriptors from the input
**    descriptor <symDesc>. Fill the descriptors into the supplied
**    symDescArray[numRequested].  Return the actual number of symbol
**    descriptors filled in.
**    If the input <symDesc> is a NULL_DESCRIPTOR and the <basicSymType>
**    is SYM_MODULE, then retrieve all module descriptors started from the
**    modules list head.
**    If the input <symDesc> is a NULL_DESCRIPTOR and the <basicSymType>
**    is SYM_PUBLIC_LABEL, then retrieve all public label descriptors started
**    from the public_label list head.
**
** Input parameter:
**    symDesc:      symbol descriptor for starting point
**    basicSymType: type of symbol (modules, label, functions, etc.)
**    numRequested: number of requested sibling symbols.           
**
** Output parameter:
**    symDescArray: a caller supplied symbol descriptor array -
**                  symDescArray[numRequested].
**    numReturned:  actual number of symbol returned.              
**
** Error:
**    Returns error if no symbol loaded.
**    Returns error if <basicSymType> is not a valid type for the type of
**    <symDesc>.
**
*****************************************************************************/
RETCODE EXPORT
SymGetSiblingSymbols(SYM_DESCRIPTOR      symDesc,
                     SYM_TYPE_TYPE       basicSymType,
                     U16                 numRequested,
                     SYM_DESCRIPTOR FAR* symDescArray,
                     U16 FAR*            numReturned);


/***************************************************************************
** SymGetChildSymbolsOfModule
**
** Purpose:
**    Get the specified number of child symbol descriptors of <basicSymType>
**    that are child symbols of the input <moduleDesc>. Fill the child
**    descriptors into the supplied symDescArray. Return the actual number
**    of symbol descriptors filled in.
**
** Input parameter:
**    moduleDesc:   module symbol descriptor
**    basicSymType: type of symbol (functions, block, etc.)
**    numRequested: number of requested child symbols.           
**
** Output parameter:
**    symDescArray: a caller supplied symbol descriptor array -
**                  symDescArray[numRequested].
**    numReturned:  actual number of symbol returned.              
**
** Error:
**    Returns error if no symbol loaded.
**    Returns error if <basicSymType> is not a valid type for child symbol.
**
*****************************************************************************/
RETCODE EXPORT
SymGetChildSymbolsOfModule(SYM_DESCRIPTOR      moduleDesc,
                           SYM_TYPE_TYPE       basicSymType,
                           U16                 numRequested,
                           SYM_DESCRIPTOR FAR* symDescArray,
                           U16 FAR*            numReturned);

/*****************************************************************************
** SymGetLineNumbersOfModule
**
** Purpose:
**    Get the specified number of line number descriptors of the input
**    <moduleDesc>. Fill the line number descriptors into the supplied
**    lineDescArray. Return the actual number of descriptors filling in.
**
** Input parameter:
**    moduleDesc:   module symbol descriptor
**    numRequested: number of requested line numbers.           
**
** Output parameter:
**    lineDescArray: a caller supplied line number descriptor array -
**                   lineDescArray[numRequested].
**    numReturned:  actual number of line returned.              
**
** Error:
**    Returns error if no line numbers.
**
*****************************************************************************/
RETCODE EXPORT
SymGetLineNumbersOfModule(SYM_DESCRIPTOR          moduleDesc,
                          U16                     numRequested,
                          LINENUM_DESCRIPTOR FAR* lineDescArray,
                          U16 FAR*                numReturned);

/*****************************************************************************
** SymGetLineNumbersList
**
** Purpose:
**    Get the specified number of linenumber descriptors adjacent to the
**    input <lineDesc>. Fill the linenum descriptors into the supplied
**    lineDescArray. Return the actual number of descriptors filling in.
**
** Input parameter:
**    moduleDesc:   module contained the line numbers   
**    lineDesc:     start linenumber descriptor
**    numRequested: number of requested linenumbers.
**
** Output parameter:
**    lineDescArray: a caller supplied linenumber descriptor array -
**                   lineDescArray[numRequested].
**    numReturned:  actual number of line returned.              
**
** Error:
**    Returns error if no line numbers existed for the <moduleDesc>.
**
*****************************************************************************/
RETCODE EXPORT
SymGetLineNumbersList(SYM_DESCRIPTOR          moduleDesc,
                      LINENUM_DESCRIPTOR      startLineDesc,
                      U16                     numRequested,
                      LINENUM_DESCRIPTOR FAR* lineDescArray,
                      U16 FAR*                numReturned);

#ifdef __cplusplus
}
#endif

#define _SYMBLEXT_
#endif /* _SYMBLEXT_ */
/******************************** E O F *************************************/
