
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMCLIPR.H__   1.13   13 Dec 1996 11:20:44   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMCLIPR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:44   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:44   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:49:00   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:58   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:58   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:48   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:02   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:38   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:54   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:04   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:12   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:58   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:16   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symclipr.h
**
**  Description:
**     Prototypes for the routines that print the symbol table to the cli.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/SYMCLIPR.H__   1.13   13 Dec 1996 11:20:44   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLIPR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include "memmanag.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMCLIPR_ADDR_TEXT_WIDTH 40

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT
SymPrintSymbol(TABLE_OFFSET symbol, 
               SYM_DISPLAY_TYPE displayType,
               U16 indentLevel);

RETCODE EXPORT
SymPrintSymbols(SYM_DISPLAY_TYPE displayType);

RETCODE SymPrintLines(SYM_DESCRIPTOR modDesc);

//--------------------------------------------------------------------------
// SymConvSymAddrToText
//
// Output format:
//    Fixed addresses:
//       Displays fixed address as xxx-yyy where xxx is the start address and
//       yyy is the end address; then displays the range as [rrr].
//       Start and end addresses are is hex, the range is in decimal
//    Stack-based addresses:
//       Displays as a single signed decimal number followed by [sss] size.
//
// Input Parameter:
//    symbol: symbol being printed
//
// Output Parameter:
//    str: alloc'ed by caller using size SYMCLIPR_ADDR_TEXT_WIDTH
//--------------------------------------------------------------------------
RETCODE SymConvSymAddrToText(SYM_DESCRIPTOR symbol, LPSTR str);

#ifdef __cplusplus
}
#endif

RETCODE SymPrintBases(SYM_DISPLAY_TYPE displayType);

#define _SYMCLIPR_
#endif
/******************************** E O F ***********************************/
