/* File: ADDR.H
** Description: Contains definitions for addresses comparison/manipulation
*/

/* Address Types */
#define ADDR_VIRTUAL  0
#define ADDR_LINEAR   1
#define ADDR_PHYSICAL 2

/* Addresses compare result */
#define ADRLIB_ADDR_GREATER_THAN 0
#define ADRLIB_ADDR_LESS_THAN    1
#define ADRLIB_ADDR_EQUAL        2
!!

/* Address Range Adjust Types */
#define MOVE_RANGE_TO_LOW_ADDR 0
#define MOVE_RANGE_TO_HI_ADDR  1
#define EXPAND_RANGE_LOW_ADDR  2
#define EXPAND_RANGE_HI_ADDR   3
#define EXPAND_RANGE_BOTH      4

/* Address Space */
#define ADDR_SPACE_UNDEF0    0
#define ADDR_SPACE_UD        1
#define ADDR_SPACE_UP        2
#define ADDR_SPACE_UNDEF3    3
#define ADDR_SPACE_UNDEF4    4
#define ADDR_SPACE_SD        5
#define ADDR_SPACE_SP        6
#define ADDR_SPACE_CPU       7
#define ADDR_SPACE_DONT_CARE 8
#define ADDR_SPACE_USER      9
#define ADDR_SPACE_SMM      10
#define ADDR_SPACE_IO       11
#define ADDR_SPACE_ICE      12
#define ADDR_SPACE_DEFAULT  13
!!

/* Address Range components */
#define RANGE_START 0
#define RANGE_END   1
#define RANGE_BOTH  2

/* Address Operand/Address Size */
#define ADDR_USE_AUTO 0
#define ADDR_USE_16   1
#define ADDR_USE_32   2

/* Address segment selectors */
#define ADDR_USE_VALUE  0
#define ADDR_USE_CS     1
#define ADDR_USE_DS     2
#define ADDR_USE_SS     3
#define ADDR_USE_ES     4
#define ADDR_USE_FS     5
#define ADDR_USE_GS     6
#define ADDR_USE_DEF_DS 7

/* Address modes */
#define ADDR_MODE_NONE    0
#define ADDR_MODE_CURRENT 1
#define ADDR_MODE_REAL    2
#define ADDR_MODE_PROT16  3
#define ADDR_MODE_PROT32  4
#define ADDR_MODE_V86     5
#define ADDR_MODE_SMM     6

/*  E O F  */
!!
