/* ANOTEXT.H -- Annotated Text Encodings */
/*
**
** Text is annotated by special byte-encodings:
**
**  ____________
**  |1|XX|YYYYY| <-- bit layout of special byte
**  ------------
**   1, 2,   5   <-- bit width
**
** High Bit: 
**   0 => ASCII
**   1 => Special
**
** 2 Tag Bits:
**   0 => reserved
**   1 => other 5 bits are # of indents (tabs)
**   2 => Begin a typed region (5 bits of type/class)
**   3 => End a typed region   (5 bits of type/class)
**
** 5 Other Bits: if tag is 2 or 3
**   0 => reserved
**   1 => type name
**   2 => variable name
**   3 => editable value
**   4 => expandable reference
**   5 => breakpoint set -- active
**   6 => breakpoint set -- inactive
**   7 => breakpoint hit
**   8 => cursor (link active)
**   9 => cursor (link inactive)
**  10 => current execution point (PC is here)
**  11..31 => reserved
**
**  NOTES:
**     Begin..End regions may be nested, but may *not* overlap
**     (this allows "recursive descent" type parsing).
*/

#define AT_SPECIAL_MARK 0x80
#define AT_SPECIAL_MASK 0x80

#define AT_TAG_MASK    0x60
#define AT_INDENT_TAG  0x20
#define AT_BEGIN_TAG   0x40
#define AT_END_TAG     0x60

#define AT_FIELD_MASK         0x1F
#define AT_TYPE_NAME_FIELD    0x01
#define AT_VAR_NAME_FIELD     0x02
#define AT_EDIT_FIELD         0x03
#define AT_REFERENCE_FIELD    0x04
#define AT_BREAK_ACT_FIELD    0x05
#define AT_BREAK_INACT_FIELD  0x06
#define AT_BREAK_HIT_FIELD    0x07
#define AT_CURSOR_ACT_FIELD   0x08
#define AT_CURSOR_INACT_FIELD 0x09
#define AT_PC_HERE_FIELD      0x0A
#define AT_SELECTED_FIELD     0x0B

/*                             --  E O F  --                              */
