/* ATrigger.h  -- Actor #defines for trigger server dll enums

==> SEE "trig.h" in "tbird\ice\inc"
*/

/* ACTION_MASK */

#define TRIG_NULL_ACTION    0x0000
#define TRIG_SEQ_ACTION   0x0001
#define TRIG_RESET_ACTION   0x0002
#define TRIG_TRG_CONT_ACTION   0x0004
#define TRIG_TRG_HALT_ACTION   0x0008
#define TRIG_EM_BREAK_ACTION   0x0010
#define TRIG_INC_0_ACTION   0x0020
#define TRIG_INC_1_ACTION   0x0040
#define TRIG_RESET_0_ACTION   0x0080
#define TRIG_RESET_1_ACTION   0x0100
#define TRIG_TIMER_START_ACTION  0x0200
#define TRIG_TIMER_STOP_ACTION   0x0400
#define TRIG_TIMER_RESET_ACTION  0x0800
#define TRIG_EXT_TIMER_ON        0x1000
#define TRIG_EXT_TIMER_OFF       0x2000


/* TRACE_MODE (sdtrace.h) */
#define  PRE_TRACE               0x0000
#define  POST_TRACE              0x0001
#define  CENTER_TRACE            0x0002

/* COUNTER_TYPE */

#define TRIG_AS_COUNTER  0x0000
#define TRIG_AS_TIMER  0x0001

/* QUALIFIER MODE TYPES */
#define QUALIFY_AS_CLOCK  0x0000
#define QUALIFY_AS_BUS    0x0001


/* EVENT_COND */

#define TRIG_EV_0_COND  0x0001
#define TRIG_EV_1_COND  0x0002
#define TRIG_EV_2_COND  0x0004
#define TRIG_EV_3_COND  0x0008
#define TRIG_EV_4_COND  0x0010
#define TRIG_EV_5_COND  0x0020
#define TRIG_EV_6_COND  0x0040
#define TRIG_EV_7_COND  0x0080
#define TRIG_TC_0_COND  0x0100
#define TRIG_TC_1_COND  0x0200
#define TRIG_EXT_COND  0x0400

/* checkbox field type */
#define COUNTER_BOX     0x0001
#define TIMER_BOX       0x0002

/* * * * * * * * * * * * * * * EVENT PRESENTER * * * * * * * * * * * * * * */

#define ADDR_NOT_BOX       700
#define ADDR_START_FIELD   701
#define ADDR_END_FIELD     702
#define ADDR_MASK_FIELD    703
#define ADDR_END_ADDR_BOX  704
#define ADDR_END_LEN_BOX   705
#define DATA_NOT_BOX       706
#define DATA_START_FIELD   707
#define DATA_END_FIELD     708
#define DATA_MASK_FIELD    709

#define SPACE_GROUP_BOX_ID 800
#define UD_BOX_ID          900
#define UP_BOX_ID          901
#define SD_BOX_ID          902
#define SP_BOX_ID          903
#define CPU_BOX_ID         904

#define FIRST_STATUS_ID   1000 /* status radio button start with this ID */

#define ADDR_SPACE_UD      1        /* user data */
#define ADDR_SPACE_UP      2        /* user program */
#define ADDR_SPACE_SD      5        /* supervisor data */
#define ADDR_SPACE_SP      6        /* supervisor program */
#define ADDR_SPACE_CPU     7        /* cpu */

#define END_ADDR_FUNC      0
#define END_LEN_FUNC       1

#define IO_FUNC            0
#define SELF_FUNC          1
#define CS8_FUNC           2
#define CS16_FUNC          3

#define MAX_EVENT_NAME     63      /* must match value in event.c */
/*   -- E O F ---   */
