/* misc utilities for CLI; implemented as class methods */!!

inherit(Object, #CLIUtilities, nil, 2, nil)!!

setClassVars(CLIUtilities, #($DoubleQuoteString  /* string containing a double quote */,
$KeywordToTokenValue
  /* map keywords to token values */,
$TokenValueToKeyword
  /* map token values to keywords */))!!

now(class(CLIUtilities))!!

/* clear the abort key to "not hit".
 *  left here for PV2.0. 28-Jul-93-prd
 *   should not be called from anywhere
 */
Def clearAbort(self)
{
  if TaskLibClass$Inst then
      ^queryAbort(TaskLibClass$Inst);
  endif;
  ^0;
}
!!


/* 3/26/1992 13:53 */
Def doubleQuoteString(self)
{
  ^$DoubleQuoteString;
}
!!

/* get the string equivalent of the operator token. */
Def getOperatorString(self, op | value errorMessage)
{
  select
    case op = TAMPER       is value := "&";  endCase;
    case op = TBAR         is value := "|";  endCase;
    case op = TEQUALS      is value := "=";  endCase;
    case op = TEQUAL_TO    is value := "=="; endCase;
    case op = TEXCLAM      is value := "!";  endCase;
    case op = TGREATER_EQ  is value := ">="; endCase;
    case op = TLEFT_CURLY  is value := "{";  endCase;
    case op = TLEFT_PAREN  is value := "(";  endCase;
    case op = TLESS_EQ     is value := "<="; endCase;
    case op = TLOG_AND     is value := "&&"; endCase;
    case op = TLOG_OR      is value := "||"; endCase;
    case op = TLSHIFT      is value := "<<"; endCase;
    case op = TL_ANGLE     is value := "<";  endCase;
    case op = TMINUS       is value := "-";  endCase;
    case op = TNOT_EQUAL   is value := "!="; endCase;
    case op = TPERCENT     is value := "%";  endCase;
    case op = TPLUS        is value := "+";  endCase;
    case op = TRIGHT_CURLY is value := "}";  endCase;
    case op = TRIGHT_PAREN is value := ")";  endCase;
    case op = TRSHIFT      is value := ">>"; endCase;
    case op = TR_ANGLE     is value := ">";  endCase;
    case op = TSLASH       is value := "/";  endCase;
    case op = TSTAR        is value := "*";  endCase;
    case op = TTILDE       is value := "~";  endCase;
    case op = TUPARROW     is value := "^";  endCase;
    default
      errorMessage := getFormattedError(ErrorTextLibClass$Inst,
         ER_CLI_INTERNAL_ERROR, "CliUtilities:getOperatorString",
         nil, nil);
      syntaxError(self, nil, errorMessage);
      /* syntaxError unravels call stack, and does not return */
  endSelect;
  ^value;
}!!

/* retrieve the string resource */
Def getStringResource(self, dll, index | buffer length)
{
  if (index < 0) cor (index > 0xFFFF)
    ^nil;
  endif;

  buffer := stringOf(' ', 256); /* create buffer */
  length := Call LoadString(dll, index, buffer, 255);
  if (length) cand (length > 0)
    ^removeNulls(buffer);
  else
    ^"";
  endif;
}!!

/* look up keyword in table; return token type if found, nil if not. */
Def keywordToTokenValue(self, keyword)
{
  ^at($KeywordToTokenValue, keyword);
}
!!

/* return nil if abort key not struck.
   return 0 if abort key struck.
   if error, return esc struck (0)
  */
Def queryAbort(self | keyHit)
{
  if TaskLibClass$Inst then
      ^queryAbort(TaskLibClass$Inst);
  endif;
}
!!

/* return the input string as a double-quoted string. */
Def quote(self, string)
{
  ^$DoubleQuoteString + string + $DoubleQuoteString;
}
!!

/* look up token value in table; return keyword if found, nil if not. */
Def tokenValueToKeyword(self, tokenValue)
{
  ^at($TokenValueToKeyword, tokenValue);
}
!!

/* remove quote marks which are assumed to be
   the first and last characters in string */
Def unquote(self, string)
{
  ^subString(string, 1, size(string)-1);
}
!!

now(CLIUtilities)!!

/* CLIUtilities Class Initialization Code */

$DoubleQuoteString := asString(asChar(34));

/* create a keyword-to-token-value mapping dictionary */
$KeywordToTokenValue := new(Dictionary, 15); !!
add($KeywordToTokenValue, "alias", TALIAS); !!
add($KeywordToTokenValue, "append", TAPPEND); !!
add($KeywordToTokenValue, "call", TCALL); !!
add($KeywordToTokenValue, "clear", TCLEAR); !!
add($KeywordToTokenValue, "delete", TDELETE); !!
add($KeywordToTokenValue, "echo", TECHO); !!
add($KeywordToTokenValue, "else", TELSE); !!
add($KeywordToTokenValue, "exit", TEXIT); !!
add($KeywordToTokenValue, "file", TFILE); !!
add($KeywordToTokenValue, "help", THELP); !!
add($KeywordToTokenValue, "help_", THELP_); !!
add($KeywordToTokenValue, "history", THISTORY); !!
add($KeywordToTokenValue, "if", TIF); !!
add($KeywordToTokenValue, "include", TINCLUDE); !!
add($KeywordToTokenValue, "integer", TINTEGER); !!
add($KeywordToTokenValue, "laptimer", TLAPTIMER); !!
add($KeywordToTokenValue, "list", TLIST); !!
add($KeywordToTokenValue, "log", TLOG); !!
add($KeywordToTokenValue, "logging", TLOGGING); !!
add($KeywordToTokenValue, "off", TOFF); !!
add($KeywordToTokenValue, "on", TON); !!
add($KeywordToTokenValue, "overwrite", TOVERWRITE); !!
add($KeywordToTokenValue, "print", TPRINT); !!
add($KeywordToTokenValue, "results", TRESULTS); !!
add($KeywordToTokenValue, "starttimer", TSTARTTIMER); !!
add($KeywordToTokenValue, "stoptimer", TSTOPTIMER); !!
add($KeywordToTokenValue, "string", TSTRING); !!
add($KeywordToTokenValue, "transcript", TTRANSCRIPT); !!
add($KeywordToTokenValue, "time", TTIME); !!
add($KeywordToTokenValue, "while", TWHILE); !!
add($KeywordToTokenValue, "workdir", TWORKDIR); !!

/* create a reverse-mapping function to map token values onto keyword strings */
$TokenValueToKeyword := new(Dictionary, 18); !!
assocsDo ($KeywordToTokenValue,
     { using(assoc)
         add($TokenValueToKeyword, value(assoc), key(assoc));
     });
!!