/* node for a CLI while statement:
    CLI:  while (expression) { body }
    Actor:  loop while (expression) begin body endLoop; */!!

inherit(Object, #CLIWhileNode, #(expression  /* expression of the while stmt */
body       /* body of the while statement */), 2, nil)!!

now(class(CLIWhileNode))!!

now(CLIWhileNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self)
{
  CLICodeCompile("loop while (cTrue(self, ");
  expressionEchoOff(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(expression);
  expressionEchoOn(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(")) begin ");
  CLICodeCompile(body);
  CLICodeCompile("cA(self);");
  CLICodeCompile(" endLoop ");
}
!!

Def init(self, exp, bod)
{
  expression := exp;
  body := bod;
}!!
