/****************************************************************************
**
**  Name:  EVENTS.H
**
**  Description:
**      All events used by PowerViews servers are enumerated here.
**      NOTES: ALL EVENTS DEFINED IN \INC\EVENTS.H MUST MATCH EXACTLY.
**    
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/
!!

#define EVENT_MSG 0x480

/* Event a callback can propagate to close the application */

#define EVENT_CLOSE_APPLICATION        0x0FFF001EL  /*MODULE_GENERIC|30*/

!!
/* Events in the id 20-29 range are supported by multiple servers/presenters.
   Specifically,
        Halted events are EVENT_xxx_HALTED, and id 20
        Edit events are EVENT_xxx_EDIT, and id 21
   Events in the 30-49 range for all other events.
   Events starting at 50 are internal (not used by more than a single
       component).
*/

#define EVENT_BKPT_HALTED              0x00040014L /*MODULE_BREAKPOINT|20*/
#define EVENT_BKPT_EDIT                0x00040015L /*MODULE_BREAKPOINT|21*/

/* High Level event for presenters indicating emulation started successfully*/

#define EVENT_HL_BKPTEXEC_EMUL_STARTED 0x0004001EL /*MODULE_BREAKPOINT|30*/

/* High Level event for presenters indicating emulator is being stepped but
   is not done yet */

#define EVENT_HL_BKPTEXEC_EMUL_STEPPING 0x0004001FL /*MODULE_BREAKPOINT|31*/
!!
/* generated when any breakpoint information changes */
/* users should get all their pertinent breakpoint information for update */

#define EVENT_BKPTEXEC_BKPT_CHANGED    0x00040020L /*MODULE_BREAKPOINT|32*/

/* Low Level event indicating emulation started successfully; not to be used
   by presenters */

#define EVENT_LL_BKPTEXEC_EMUL_RUNNING 0x00040032L  /*MODULE_BREAKPOINT|50*/
!!
/* Low Level event indicating emulation has stopped; not to be used by
   presenters */

#define EVENT_LL_BKPTEXEC_EMUL_HALTED  0x00040033L  /*MODULE_BREAKPOINT|51*/

/* event to make sure all other events have completed after a call */
#define EVENT_CLI_COMMAND_COMPLETE     0x00200050L  /*MODULE_CLI|50 */

#define EVENT_CPU_HALTED               0x00050014L /*MODULE_CPU|20*/
#define EVENT_CPU_EDIT                 0x00050015L /*MODULE_CPU|21*/
#define EVENT_CPU_PC_EDIT              0x0005001EL /*MODULE_CPU|30*/
#define EVENT_CPU_SP_EDIT              0x0005001FL /*MODULE_CPU|31*/
#define EVENT_CPU_FP_EDIT              0x00050020L /*MODULE_CPU|32*/
!!
#define EVENT_DASM_HALTED              0x00060014L /*MODULE_DISASSEMBLY|20*/
#define EVENT_DASM_SYM_CHANGED         0x00060015L /*MODULE_DISASSEMBLY|21*/

#define EVENT_LDR_START_PC             0x0009001EL /*MODULE_LOADER_695|30*/
#define EVENT_LDR_STACK_TOP            0x0009001FL /*MODULE_LOADER_695|31*/
#define EVENT_LDR_LOAD_COMPLETE        0x00090020L /*MODULE_LOADER_695|32*/
!!
/* generated whenever map changes... memory should be updated */

#define EVENT_MAP_EDIT                 0x00140015L /*MODULE_MAP|21*/

#define EVENT_MEM_HALTED               0x000B0014L /*MODULE_MEMORY|20*/
!!
/* generated whenever any memory location(s) may have changed */

#define EVENT_MEM_EDIT                 0x000B0015L /*MODULE_MEMORY|21*/
!!
/* events used to update src windows if memory change matches their range */

#define EVENT_MEM_MEMORY_CHANGED_SRC0_RANGE 0x000B001FL /*MODULE_MEMORY|31*/
#define EVENT_MEM_MEMORY_CHANGED_SRC1_RANGE 0x000B0020L /*MODULE_MEMORY|32*/

#define EVENT_STK_HALTED               0x000D0014L /*MODULE_STACK |20*/
!!
/* generated when stack frame is recalculated */
#define EVENT_STK_STACK_CHANGED        0x000D001EL /*MODULE_STACK |30*/

/* generated when the stack alarm is tested and found to be over the limit */
#define EVENT_STK_ALARM_OVER_LIMIT     0x000D001FL /*MODULE_STACK |31*/
!!
/* generated when the alarm conditions change */
#define EVENT_STK_ALARM_CHANGE         0x000D0020L /*MODULE_STACK|32*/
#define EVENT_STK_ALARM_ENABLED        0x000D0021L /*MODULE_STACK|33*/
#define EVENT_STK_ALARM_DISABLED       0x000D0022L /*MODULE_STACK|34*/
!!
/* generated when the HWM conditions change */
#define EVENT_STK_HWM_ENABLED          0x000D0023L /*MODULE_STACK |35*/
#define EVENT_STK_HWM_DISABLED         0x000D0024L /*MODULE_STACK |36*/
#define EVENT_STK_STACK_OVERFLOW       0x000D0025L /*MODULE_STACK |37*/
#define EVENT_STK_STACK_UNDERFLOW      0x000D0026L /*MODULE_STACK |38*/
#define EVENT_STK_BASE_SIZE_AVAIL      0x000D0027L /*MODULE_STACK |39*/
!!

/* generated after an initial symbol load */
#define EVENT_SYMBOL_INIT_LOAD     0x0002001EL /*MODULE_SYMBOLS|30*/

/* generated after a single module's on-demand symbols are loaded */
#define EVENT_SYMBOL_ONDEMAND_LOAD 0x0002001FL /*MODULE_SYMBOLS|31*/

/* generated after symbols have been deleted */
#define EVENT_SYMBOL_DELETED       0x00020020L /*MODULE_SYMBOLS|32*/
!!
/* generated whenever a base address has been changed via the CLI */
/* this is needed by any presenter or server that has stored a symbol and */
/* its address, since the address may have changed if that symbol is in the
/* group associated with the changed base */
!!
#define EVENT_SYMBOL_BASE_CHANGED  0x00020021L /*MODULE_SYMBOLS|33*/
#define EVENT_TRACE_CLEAR_TRACE    0x000F001EL /*MODULE_TRACE|30*/
#define EVENT_TRACE_DEBUG_EMON     0x000F001FL /*MODULE_TRACE|31*/
#define EVENT_TRACE_NEW_SUB_BUFFER 0x000F0020L /*MODULE_TRACE|32*/
#define EVENT_TRACE_TRACING_OFF    0x000F0021L /*MODULE_TRACE|33*/
#define EVENT_TRACE_TRACING_ON     0x000F0022L /*MODULE_TRACE|34*/
#define EVENT_TRACE_HEADER_CHANGED 0x000F0023L /*MODULE_TRACE|35*/
!!
#define EVENT_TRIG_HALTED      0x00100014L /*MODULE_TRIGGER|20*/
#define EVENT_TRIG_TRC_BUF_NUM 0x00100015L /*MODULE_TRIGGER|21*/
#define EVENT_VAR_HALTED       0x00110014L /*MODULE_VAR|20*/
#define EVENT_VAR_EDIT         0x00110015L /*MODULE_VAR|21*/
!!
/* Events report status of RUNACCESS to presenter */
#define EVENT_BKROOT_RUNACCESS_ON    0x00170014L  /*MODULE_BKROOT | 20*/
#define EVENT_BKROOT_RUNACCESS_OFF   0x00170015L  /*MODULE_BKROOT | 21*/
!!
/* event used by X86 when a change is detected in processor mode */
#define EVENT_ADR_PMODE_CHANGED      0x0003001EL  /*MODULE_ADDRESS | 30*/
!!

/* END OF FILE */
