/* instance of event template server */!!

inherit(EvttmpltLib, #EventTemplate, #(descriptor), 2, nil)!!

now(class(EventTemplate))!!

now(EventTemplate)!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltDisplayBusControlSignals(self | status rc) {
  status := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTDISPLAYBUSCONTROLSIGNALS], status);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ; 
  if( rc <> 0 )
    ^0;
  else
    ^wordAt(status,0);
  endif;
}
!!

/* PUBLIC */
Def descriptor(self)
{ 
  ^descriptor
}
!!

/* PRIVATE */
Def init(self)
{
  /* init state vars */
}
!!

/* PRIVATE */
Def setDescriptor(self, d)
{
  descriptor := d ;
}!!

/* PRIVATE */
Def setProcs(self, p)
{
  procs := p ;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltDisplayAddressSpace(self | status rc) {
  status := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTDISPLAYADDRESSSPACE], status);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  if( rc <> 0 )
    ^0;
  else
    ^wordAt(status,0);
  endif;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltGetFieldType(self | rc type)
{
  type := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTGETFIELDTYPE], descriptor, type);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^wordAt(type,0);
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltGetNameGivenFieldNumber(self, num | rc name)
{
  name := new(String,64);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTGETNAMEGIVENFIELDNUMBER], descriptor, num,
                             name, 64);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
  then
    ^"" ;
  else
    ^ removeNulls(name);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltGetNumOfEntries(self | rc num)
{
  num := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTGETNUMOFENTRIES], descriptor, num);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^wordAt(num,0);
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltGetVisible(self | rc type)
{
  type := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTGETVISIBLE], descriptor, type);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^wordAt(type,0);
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltRestoreTemplates(self, fileName | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTRESTORETEMPLATES], asciiz(fileName));
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltSaveTemplates(self, fileName | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTSAVETEMPLATES], asciiz(fileName));
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltSetTemplateName(self, name | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#TMPLTSETTEMPLATENAME], descriptor, asciiz(name));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def tmpltWhatsPinsFunction(self, chipSelect pinType| type rc) {
  type := new(Struct,4);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTWHATSPINSFUNCTION], chipSelect, type);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  pinType := wordAt(type,0);
  ^rc
}
!!

Def tmpltGetDigitLength(self | rc digits)
{
  digits := new(Struct,2);
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTGETDIGITLENGTH], descriptor, digits);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^wordAt(digits,0);
}!!


