/* instance of event template server */!!

inherit(ProvidedLibs, #EvttmpltLib, #(initialized), 2, nil)!!

setClassVars(EvttmpltLib, #())!!

now(class(EvttmpltLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize( new(self:ancestor), path )
}
!!

now(EvttmpltLib)!!

/* PRIVATE */
Def addImportProcs(self)
{
  add( self, #INITCSERVER, 1, #(0, 0) ) ;
  add( self, #TMPLTOPENTEMPLATE, 1, #(1) ) ;
  add( self, #TMPLTRESTORETEMPLATES, 1, #(1) ) ;
  add( self, #TMPLTSAVETEMPLATES, 1, #(1) ) ;
  add( self, #TMPLTSETTEMPLATENAME, 1, #(1,1) ) ;
  add( self, #TMPLTGETFIELDTYPE, 1, #(1,1) ) ;
  add( self, #TMPLTGETVISIBLE, 1, #(1,1) ) ;
  add( self, #TMPLTGETNUMOFENTRIES, 1, #(1,1) ) ;
  add( self, #TMPLTGETNAMEGIVENFIELDNUMBER, 1, #(1,0,1,0) ) ;
  add( self, #TMPLTWHATSPINSFUNCTION, 1, #(0,1) ) ;
  add( self, #TMPLTDISPLAYADDRESSSPACE, 1, #(1) ) ;
  add( self, #TMPLTDISPLAYBUSCONTROLSIGNALS, 1, #(1) ) ;
  add( self, #TMPLTGETDIGITLENGTH, 1, #(1, 1) ) ;
}!!

/* PUBLIC -- create a event instance */
Def eventTemplateOpen(self | aEventTemplate, rc, descriptorPtr) 
{ 
  aEventTemplate := new( EventTemplate ) ;
  descriptorPtr := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TMPLTOPENTEMPLATE], descriptorPtr) ;
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^nil ;
  endif ;
  setDescriptor( aEventTemplate, longAt(descriptorPtr, 0) );
  setProcs( aEventTemplate, procs(self) ) ;
  ^aEventTemplate
}!!

/* EvttmpltLib Class Initialization Code */
