/* File: GLOBALS.H
** Description: Contains global definitions being used by multiple classes.
** Include: none.
*/

/* PUBLIC - Return value constants */
#define GOOD 0
#define BAD  1

#define BOOL_TRUE  1
#define BOOL_FALSE 0

/* PUBLIC - Windows style constants - See Windows.h */
#define LBS_USETABSTOPS       0x0080L
#define WM_SETFONT            0x0030
#define LBS_STANDARD_NOSORT   0x00A00001L

/* Windows 3.0 specific definitions - See windows.h */   
#define POLYFILL_WINDING      2
#define RGB_PURE_RED          0x000000FF
#define RGB_PURE_GREEN        0x0000FF00
#define RGB_PURE_BLUE         0x00FF0000
#define BS_SOLID              0
#define ETO_OPAQUE            2 /* windows.h */

/* Windows Virtual Keys, Standard Set */
#define VK_LBUTTON          0x01
#define VK_RBUTTON          0x02
#define VK_CANCEL           0x03
#define VK_MBUTTON          0x04    /* NOT contiguous with L & RBUTTON */
#define VK_BACK             0x08
#define VK_TAB              0x09
#define VK_CLEAR            0x0C
#define VK_RETURN           0x0D
#define VK_SHIFT            0x10
#define VK_CONTROL          0x11
#define VK_MENU             0x12
#define VK_PAUSE            0x13
#define VK_CAPITAL          0x14
#define VK_ESCAPE           0x1B
#define VK_SPACE            0x20
#define VK_PRIOR            0x21
#define VK_NEXT             0x22
#define VK_END              0x23
#define VK_HOME             0x24
#define VK_LEFT             0x25
#define VK_UP               0x26
#define VK_RIGHT            0x27
#define VK_DOWN             0x28

#define VK_SELECT           0x29
#define VK_PRINT            0x2A
#define VK_EXECUTE          0x2B
#define VK_SNAPSHOT         0x2C
#define VK_INSERT           0x2D
#define VK_DELETE           0x2E
#define VK_HELP             0x2F

#define VK_F1               0x70
#define VK_F2               0x71
#define VK_F3               0x72 /* already df'd by Actor (somewhere) */
#define VK_F4               0x73
#define VK_F5               0x74
#define VK_F6               0x75
#define VK_F7               0x76
#define VK_F8               0x77
#define VK_F9               0x78
#define VK_F10              0x79

/* Windows Menu - ID of presenters */
#define WINDOWS_MENU        1000
#define CLI_WINDOW          1001
#define STACK_WINDOW        1002
#define CPU_WINDOW          1003
#define MEM_WINDOW          1004
#define BKPT_WINDOW         1005
#define SOURCE_WINDOW       1006
#define TRIGGER_WINDOW      1007
#define TRACE_WINDOW        1008

#define CASCADE_WINDOW      1009
#define TILE_WINDOW         1010

/* Help Menu */
#define HELP_MENU           1020
#define INDEX_HELP          1021
#define KEYBOARD_HELP       1022
#define COMMANDS_HELP       1023
#define PROCEDURES_HELP     1024
#define GLOSSARY_HELP       1025
#define USING_HELP          1026
#define ABOUT_HELP          1027 

/* ID Help for dialog box */
/* ACTWIND.H defines IDOK to IDNO from 0 to 7 */
#define IDHELP 8

/* How much memory we must have to load: */
#define MIN_WIN_MEMORY 4500000
/* E O F */
