/* File: PROC.H
** Description: Contains definitions for the PROC dll.
** Include: GLOBALS.H
*/
   
/* processor endian */
#define PROC_LITTLE_ENDIAN    0
#define PROC_BIG_ENDIAN       1

/* processor family */
#define PROC_FAMILY_UNKNOWN   0
#define PROC_FAMILY_680X0     1
#define PROC_FAMILY_X86       2

/* processor type */
/* must match values in sdtempl.h */
#define PROC_MC68330          0x1001
#define PROC_MC68331          0x1002
#define PROC_MC68332          0x1003
#define PROC_MC68333          0x1004
#define PROC_MC68340          0x1005
#define PROC_MC68HC16Y1       0x1006
#define PROC_MC68HC16Z1       0x1007
!!

#define PROC_MC68330_SH       0x1081
#define PROC_MC68340_SH       0x1086

#define PROC_MC68360_TB       0x1101
#define PROC_MC68349_TB       0x1102
#define PROC_MC68360_SH       0x1103
#define PROC_MC68349_SH       0x1104

#define PROC_I80386CX_TB      0x1501
#define PROC_I80386SX_TB      0x1502
#define PROC_I80386EX_TB      0x1503
#define PROC_I80386DX_TB      0x1504
#define PROC_I80386CX_SH      0x1505
#define PROC_I80386SX_SH      0x1506
#define PROC_I80386EX_SH      0x1507
#define PROC_I80386DX_SH      0x1508

!!

/* processor fetch size */
#define PROC_BYTE             0
#define PROC_WORD             1
#define PROC_LONG             2
#define PROC_DWORD            3

/* system type */
#define PROC_POWERPACK        0
#define PROC_POWERSCOPE       1
#define PROC_MICEPACK         2
#define PROC_DUMMY            0xFFFF

/* cpu type */
#define PROC_CPU_68000 0
#define PROC_CPU_68010 1
#define PROC_CPU_68020 2
#define PROC_CPU_68030 3
#define PROC_CPU_68040 4
#define PROC_CPU_CPU32 5
#define PROC_CPU_CPU32P 6
#define PROC_CPU_CPU16 7
#define PROC_CPU_80186 8
#define PROC_CPU_80386 9
#define PROC_CPU_80486 10
#define PROC_CPU_DUMMY 0xFFFF


/* E O F */
