/* This class controls access to/from the private .ini file. */!!

inherit(Object, #ProfileControl, nil, 2, nil)!!

setClassVars(ProfileControl, #(fname))!!

now(class(ProfileControl))!!

/* 6/18/1992 10:25 */
/* Find the applications .ini file and save its location.  If there
   isn't one then report an error */
Def findIni(self | tmpFile winPath numChars)
{ 
fname := new(String,256);
fname := getProfileString(System,"PowerViews","pwrviewdir");

if (size(fname) == 0)
then 
     /* get the path to the users Windows directory */
     winPath := new(String,256);
     numChars := Call GetWindowsDirectory(winPath,256);
     /* find the interesting part of the path info and */
     /* then append our .ini filename */
     winPath := subString(winPath, 0, numChars);
     winPath := winPath + "\" + "mp186.ini";
     tmpFile := exists(File,winPath, 0);
     /* check to see if the ini file exists */
     if not(tmpFile)
     then /* return an error if it doesn't exist */
       ^ERR_FILE_NOT_FOUND;
     endif;
     /* store the filename and then close the file */
     fname:=fileName(tmpFile);
     close(tmpFile);
else /* make sure the filename specified in win.ini exists */
     tmpFile := exists(File,fname, 0);
     if not(tmpFile)
     then 
       ^ERR_FILE_NOT_FOUND;
     endif;
     /* close the file, fname already holds the filename */
     close(tmpFile);
endif;

}
!!

/* 6/18/1992 10:54 */
Def getFilename(self)
{ 
   ^fname;
}
!!

now(ProfileControl)!!

/* 12/10/1992 9:56 - PRIVATE 
  Get ini value number (decimal) of the specified profile String.
    Return the integer value or nil.
*/
Def getIniValueStr(self, appName, profileStr | profileValue)
{ 
  if (profileValue := getProfileEntry(self, appName, profileStr, "")) 
    cand (size(profileValue) > 0) cand profileValue[0] then
    ^profileValue[0];
  endif;
  ^nil; 
}
!!

/* 12/10/1992 9:56 - PRIVATE 
  Get ini value number (decimal) of the specified profile String.
    Return the integer value or nil.
*/
Def getIniValueNum(self, appName, profileStr | profileValue)
{ 
  if (profileValue := getProfileEntry(self, appName, profileStr, "")) 
    cand (size(profileValue) > 0) cand profileValue[0] then
    ^asInt(profileValue[0], 10);
  endif;
  ^nil; 
}
!!

/* 8/7/1992 16:48 - PUBLIC
  Convert an Actor boolean value #true/nil -> 1/0
*/
Def asCBoolean(self, actorValue)
{ 
  if actorValue then
    ^1;
  else
    ^0;
  endif;  
}
!!

/* 6/18/1992 13:06 */
/* Using the ini file application name and key name return an ordered
   collection of parsed string entries.  The parsing is done using a caller
   supplied parse string */
Def getProfileEntry(self, appName, keyName, delimeterString | numChars, 
                   returnString, iniReturnColl, begPos, endPos, collEntries)
{
  numChars := Call GetPrivateProfileString(asciiz(appName), asciiz(keyName),
    asciiz(""), returnString := new(String,256), 256,
    asciiz(getFilename(ProfileControl)));
  /* prepare to parse the return string and send back the parsed components */
  /* make the return collection arbitrarily small.  The insert method will */
  /* grow the collection if needed */
  returnString := subString(returnString, 0, numChars);
  iniReturnColl := new(OrderedCollection, 5);
  
  /* return a nil if there is no valid entry */
  if (numChars = 0) then
    iniReturnColl := nil;
    ^iniReturnColl;
  endif;
  
  collEntries := begPos := endPos := 0;
  loop
  while not(endPos == numChars)
  begin
    /* insert the parsed sub string into the collection */ 
    insert(iniReturnColl, 
           subString(returnString,begPos, 
           endPos := upTo(returnString,delimeterString,begPos)), 
           collEntries);
    /* start parsing the string one past the delimeter */
    begPos := endPos+1;
    collEntries := collEntries + 1;
  endLoop;
  
  ^iniReturnColl;                                  
}
!!

/* 6/18/1992 12:58 */
/* Using the application name and key name of an entry in the private
   ini file, save the supplied string */
Def saveProfileEntry(self, appName, keyName, entryString)
{ 
  if not(Call WritePrivateProfileString(asciiz(appName), asciiz(keyName), 
              asciiz(entryString), asciiz(getFilename(ProfileControl))))
  then
    ^displayError(ErrorTextLibClass$Inst,ERR_PROFILE_WRITE_FAIL,FORCE_POPUP);
  endif;
}!!

/* ProfileControl Class Initialization Code */