/* File: PSOURCE.H
** Description: Contains menu and child controls id of the Source Presenter.
** Include: GLOBALS.H & EVENTS.H
*/
/*
*** Main Menu Id
 */
/* File Menu */
#define SRC_FILE_OPEN             100
#define SRC_FILE_LOAD_INFO        101
#define SRC_FILE_BACK             102
#define SRC_FILE_FORWARD          103
#define SRC_FILE_MODULES          104
#define SRC_FILE_SAVE_PRJ         105
#define SRC_FILE_RESTORE_PRJ      106
#define SRC_FILE_EXIT             107
!!

#define MAX_FILE_MENU_POSITION    4   /* index start from 0 */
#define MAX_LRU_LOADFILES         4
#define MAX_SRC_PATHS             50
!!
/* View menu */
#define SRC_VIEW_SOURCE           120
#define SRC_VIEW_MIX              121
#define SRC_VIEW_LINKED_CURSOR    122
#define SRC_VIEW_SHOW_LINENUM     123
!!
/* Execution menu */
#define SRC_CMD_GO                140
#define SRC_CMD_HALT              141
#define SRC_CMD_STEP_INTO         142
#define SRC_CMD_STEP_OVER         143
#define SRC_CMD_UNTILCALL         144
#define SRC_CMD_TILRETURN         145
#define SRC_CMD_INTOCALL          146
#define SRC_CMD_INTORETURN        147
#define SRC_CMD_GO_TOCURSOR       148
#define SRC_CMD_GO_FROMCURSOR     149
#define SRC_CMD_ANIMATE_INTO      150
#define SRC_CMD_ANIMATE_OVER      151
#define SRC_CMD_RESET             152
#define SRC_CMD_RESET_AND_GO      153
!!
/* Edit menu */
#define SRC_EDIT_SEARCH           160
#define SRC_EDIT_SEARCH_AGAIN     161
#define SRC_EDIT_GOTO_LINE        162
#define SRC_EDIT_GOTO_ADDR        163
#define SRC_EDIT_GOTO_PC          164
!!
/* Breakpoints menu */
#define SRC_BKPT_PERM_SET_BREAK   180
#define SRC_BKPT_TEMP_SET_BREAK   181
#define SRC_BKPT_CLR_BKPT         182
#define SRC_BKPT_SET_BREAK_AT     183
#define SRC_BKPT_ENABLE_BKPT      184
#define SRC_BKPT_DISABLE_BKPT     185
#define SRC_BKPT_ENABLE_ALL       186
#define SRC_BKPT_DISABLE_ALL      187
#define SRC_BKPT_CLEAR_ALL        188
#define SRC_BKPT_SHOW_BKPTS       189
!!
/* Options menu */
#define SRC_OPTN_HIST_DEP         200
#define SRC_OPTN_PATH_CONV        202
#define SRC_OPTN_LOADFILE_OPTN    203
#define SRC_OPTN_EXEC_GO_UNTIL    204
#define SRC_OPTN_EXEC_GO_INTO     205
#define SRC_OPTN_STEP_LINE_GRAN   206
#define SRC_OPTN_STEP_STMT_GRAN   207
#define SRC_OPTN_STEP_COUNT       208
#define SRC_OPTN_TAB_WIDTH        209
#define SRC_OPTN_CRLF_DELIMITER   210
#define SRC_OPTN_LF_DELIMITER     211
#define SRC_OPTN_COMPILER         212
!!
/* Function and Var Popup menu */
#define SRC_POPUP_INSPECT         500
#define SRC_POPUP_SHOW_ADDR       501
#define SRC_POPUP_BKPT_LINE_PERM  502
#define SRC_POPUP_BKPT_LINE_TEMP  503
#define SRC_POPUP_BKPT_CLEAR      504

/*
*** Execution Child ID
*/
#define GO_BUTTON                 800
#define HALT_BUTTON               801
#define STEP_BUTTON               802
#define STEPOVER_BUTTON           803
#define UNTILCALL_BUTTON          804
#define TILRETURN_BUTTON          805
#define GOTOCURSOR_BUTTON         806
#define GOFROMCURSOR_BUTTON       807
#define SPLIT_REGION_BUTTON       808
!!

/** Dialog ID **/

/* Source Paths Dialog ID */
#define DLG_SOURCE_PATHS         421
#define BTN_ADD                  101
#define BTN_EDIT                 102
#define BTN_DELETE               103
#define LB_PATHS                 104
!!
           
/* Path Alias Dialog ID */
#define DLG_PATH_ALIAS           423
#define CHECKBX_ADDTO_LIST       101

/* Load Dialog ID */
#define DLG_LOAD_FILE            424
#define BTN_OPTION               9
!!

/* Add Path Dialog ID */
#define DLG_ADD_PATH             425

/* Memory Source Range ID for Event registration - Match Memory.H */
#define MEM_SOURCE1 0
#define MEM_SOURCE2 1
!!

/* Load options code */
#define LOAD_CODE        0x000001L
#define LOAD_SYMBOL      0x000002L
#define LOAD_ONDEMAND    0x000004L
#define LOAD_ASM         0x000008L
#define LOAD_STATUS      0x000010L
#define LOAD_WARNING     0x000020L
#define LOAD_DEMANGLE    0x000040L
#define LOAD_UPDATE_BASE 0x000080L
#define LOAD_RELOAD      0x000100L
#define LOAD_MODULE      0x000200L
#define LOAD_REGISTERS   0x000400L
!!
/* E O F */
