/* ROMINIT.H - Compressed RAM data segment definitions			*/

/*

This header file contains definitions which describe the
contents of the ROM initialization segment.  The segment resides
in ROM and contains an encoded table that describes how the data
segments of a program are to be initialized in RAM.  The table is
encoded to conserve ROM space.  The segment is created by SSI's
XLink when the segment attribute ROMINIT is specified.

*/

typedef unsigned char  U8;
typedef unsigned short U16;
typedef unsigned long  U32;

/*

Record type numbers

*/

#define R_END		0	/* End of the table */
#define R_DSEL		1	/* New data selector */ 
#define R_EDATA32	2	/* Enumerated data -- 32-bit offset */
#define R_IDATA32	3	/* Iterated data -- 32-bit offset */
#define R_EDATA16	4	/* Enumerated data -- 16-bit offset */
#define R_IDATA16	5	/* Iterated data -- 16-bit offset */
#define R_LDTSEL  6  /* New LDT selector */

/*

Record sizes (without data strings)

*/

#define HS_END	   	1	/* End of the table */
#define HS_DSEL	   3	/* New data selector */ 
#define HS_EDATA32	7	/* Enumerated data -- 32-bit offset */
#define HS_IDATA32  13  /* Iterated data -- 32-bit offset */
#define HS_EDATA16	5	/* Enumerated data -- 16-bit offset */
#define HS_IDATA16	7	/* Iterated data -- 16-bit offset */
#define HS_LDTSEL    3  /* New LDT selector */


/*

ROMI_DSEL - New data selector record

*/

typedef struct
{
	U8 rectype;		/* Record type == 1 */
	U16 selector;	/* The new selector */
} ROMI_DSEL;


/*

ROMI_EDATA32 - Enumerated data record with 32-bit offset

*/

typedef struct
{
	U8 rectype;		/* Record type == 2 */
	U32 offset;		/* 32-bit offset */
	U16 datalen;  	/* Length of the data string */
				/* Data string follows here */
} ROMI_EDATA32;


/*

ROMI_IDATA32 - Iterated data record with 32-bit offset

*/

typedef struct
{
	U8 rectype;		/* Record type == 3 */
	U32 offset;		/* 32-bit offset */
   U32 dupcnt;    /* repeat count */
	U32 datalen;   /* data length */
				/* Data string follow here */
} ROMI_IDATA32;


/*

ROMI_EDATA16 - Enumerated data record with 16-bit offset

*/

typedef struct
{
	U8 rectype;		/* Record type == 4 */
	U16 offset;		/* 16-bit offset */
	U16 datalen;  	/* Length of the data string */
				/* Data string follows here */
} ROMI_EDATA16;


/*

ROMI_IDATA16 - Iterated data record with 16-bit offset

*/

typedef struct
{
	U8 rectype;		/* Record type == 5 */
	U16 offset;		/* 16-bit offset */
   U16 dupcnt;    /* repeat count */
	U16 datalen;   /* data length */
				/* Data string follows here */
} ROMI_IDATA16;

/*

ROMI_LDTSEL - New LDT selector record

*/

typedef struct
{
	U8 rectype;		/* Record type == 6 */
	U16 selector;	/* The new selector */
} ROMI_LDTSEL;


/*

Name of the ROM initialization segment

*/
#define ROMI_BASE 	"_SSI_ROMINIT_BEGIN"	/* Base segment name */

#define TRUE  1
#define FALSE 0
