/* Presenter class of the trigger specification window. */!!

inherit(MaxSizeWindow, #TriggerPresenter, #(activeLevel /* currently active level */
levelWin 
hFont   /* holds font size */
charWidth
charHeight
nonScrollArea /* size of header area that isn't scrolled */
theTrigger /* trigger instance for this window */
), 2, nil)!!

now(class(TriggerPresenter))!!

/* Return the default window style. */
Def style(self)
{ ^(WS_SYSMENU bitOr WS_MINIMIZEBOX bitOr WS_OVERLAPPED);
}!!

/* PUBLIC */
Def open(self | newInstance)
{
  newInstance := newStyle(TriggerPresenter, nil, nil, "Trigger",
                   nil, nil, style(self));
  if newInstance then show(newInstance, SW_SHOW) endif ; 
  ^newInstance ;
}!!

Def openWithPosAndState(self, sizeRect showVal | newInstance )
{
  newInstance := newStyle(TriggerPresenter, nil, nil, "Trigger",
                   sizeRect, nil, style(self));

  if newInstance then show(newInstance, showVal) endif ;
  ^newInstance ;
}!!

Def wndClass(self)
{ ^"TriggerPresenter"
}!!

/* return name of trigger icon */
Def wndIcon(self)
{ ^"trigger" }
!!

now(TriggerPresenter)!!

/* PUBLIC
 */
Def charHeight(self){
  ^charHeight;
}
!!

/* PUBLIC
 */
Def charWidth(self){
  ^charWidth;
}
!!

/* Used only by event definition window */
Def childIsClosing(self, handle)
{
}
!!

/* termination processing */
Def close(self | temp)
{ 
  /* Notify parent of close -- pdr2 */
  if parent
  then
    childIsClosing( parent, self ) ;
  endif ;

  if TheTriggerPresenter then TheTriggerPresenter := nil endif ;
  trigTriggerClose(theTrigger);
  closeSelf(levelWin);
  close(self:ancestor);
}
!!

/* PRIVATE
   Respond when the user clicks on one of our buttons.  If the message
   isn't a BN_CLICKED message pass it up to our ancestor.
   NOTES: Nghia - 10/12/93
   Clear ESC key before processing command.
 */
Def command(self, menuId, lp | actionmsg id){ 

  if actionmsg := action(menu, menuId) then
    /* Clear ESC key */
    if (TaskLibClass$Inst)
      checkAbort(TaskLibClass$Inst);
    endif;
    ^perform(self, actionmsg)
  else 
  ^command(self:ancestor, menuId, lp);
  endif;
}!!

/* PUBLIC
   Return calculated font info.
 */
Def getFont(self)
{ ^hFont;
}
!!

/* PRIVATE */
Def init(self | buttonVal value mode){
  showWaitCurs();
  setFontSize(self);
  /* Globally open trigger server */
  theTrigger :=
    triggerOpen(requireWithPath(TriggerLib, "trig.dll"), "", "default");
  if not($commonEventLib)
    $commonEventLib :=
      eventOpen(requireWithPath(EventLib, "event.dll"), "default" ) ; 
  endif;
  levelWin := newChild(TrigSpecWindow,0,self,nil);
  nonScrollArea := charHeight+4;  /* reserve pixels for title area */
  activeLevel := 0;
  trigSeqLevelSet( theTrigger, 0 ) ;
  setupLevel(levelWin);
  initMenus(self);

/**186**  mode := trigCounterFunctionGet(theTrigger); **186**/
  mode := TRIG_AS_COUNTER;
  if( mode = TRIG_AS_COUNTER )
    trigCounterMode(self)
  else
   trigTimerMode(self);
  endif;

  mode := trigQualifierGet(theTrigger);
  /* don't check clock if micepack */
  if (mode = QUALIFY_AS_BUS) cor (micepack?(ProcLibClass$Inst))
    unCheckMenuItem(self,"C&lock");
    checkMenuItem(self,"&Bus");
  else
    checkMenuItem(self,"C&lock");
    unCheckMenuItem(self,"&Bus");
  endif;

  setSize(self,locRect);
  sizeKids(self);
  showOldCurs();
}
!!

/* PRIVATE
   Initialize the menus.
 */
Def initMenus(self | aMenu)
{ 
  aMenu := new(OrderedCollection, 8);
  initMenu(self);
  
  add(aMenu, tuple("&File",tuple(
                      tuple("E&xit",   #trigExit))));
                      
  add(aMenu, tuple("&Edit",tuple(
                      tuple("E&vents...",    #trigEvent))));

  /* don't add counter or timer for micepack */
  /* CAUTION: menu updates must be done to both sets of tuples below... */
  if not(micepack?(ProcLibClass$Inst))
    add(aMenu, tuple("&Options",tuple(
                      tuple("&Trace Control...",    #trigTraceConf),
                      tuple(nil,    nil),
                      tuple("&Counter",    #trigGoCounterMode),
                      tuple("Ti&mer",    #trigGoTimerMode),
                      tuple(nil,    nil),
                      tuple("&Bus",    #trigUseBusCycles),
                      tuple("C&lock",    #trigUseClockCycles))));
  else
    add(aMenu, tuple("&Options",tuple(
                      tuple("&Trace Control...",    #trigTraceConf)
                      /*186*
                      tuple(nil,    nil),
                      tuple("&Counter",    #trigGoCounterMode),
                      tuple("Ti&mer",    #trigGoTimerMode),
                      tuple(nil,    nil),
                      tuple("&Bus",    #trigUseBusCycles),
                      tuple("C&lock",    #trigUseClockCycles) *186*/
                      )));
  endif;

  add(aMenu, tuple("&Level",tuple(
                      tuple("Show Level &0",    #level0),
                      tuple("Show Level &1",    #level1),
                      tuple("Show Level &2",    #level2),
                      tuple("Show Level &3",    #level3))));
                                                                                                                                     
  attachMenuChoices(self,aMenu);
  addWindowAndHelp(self, "Tri&gger", HELP_ENTRY_TRIGGER);
  registerF1Help(CLIULibraryClass$Inst, HI_ENTRY_TRIGGER,
     getHWnd(self), HELP_ENTRY_TRIGGER);
  /* disable Clock menu if */
  if micepack?(ProcLibClass$Inst)
    grayMenuItem(self, "C&lock");
  endif;
  drawMenu(self);
}!!

/* PRIVATE
 */
Def level0(self){
  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 0 ) ;
  activeLevel := 0;
  invalidate(self);
  setupLevel(levelWin);
}
!!

/* PRIVATE
 */
Def level1(self){
  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 1 ) ;
  activeLevel := 1;
  invalidate(self);
  setupLevel(levelWin);
}
!!

/* PRIVATE
 */
Def level2(self){
  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 2 ) ;
  activeLevel := 2;
  setupLevel(levelWin);
  invalidate(self);
}
!!

/* PRIVATE
 */
Def level3(self){
  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 3 ) ;
  activeLevel := 3;
  setupLevel(levelWin);
  invalidate(self);
}
!!

/* WINDOWS */
Def paint(self, hdc | aStr oldFont width)
{ 
  aStr := "Trigger  -  Level " + asString(activeLevel);
  setText(self,aStr);
  if oldFont := Call SelectObject(hdc,getFont(self))
    initTextColors(self,hdc);
    aStr := "Condition";
    Call TextOut(hdc, 40, 2, aStr, size(aStr));
    aStr:="Actions";
    Call TextOut(hdc, 300, 2, aStr, size(aStr));
    Call SelectObject(hdc,oldFont);
  endif;
  width := (charWidth(self) * 24)+(charWidth(self)/2);
  fill(rect(width,0,width+3,charHeight(self)*2),stock(BLACK_BRUSH),hdc); 
}
!!

/* PRIVATE
   Calculate font size given size of window.
   Currently just assigns smallest font size.
 */
Def setFontSize(self | hdc, tm, oldFont)
{ 
  /* Messing with Windows font sizes directly */
  hFont := Call CreateFont(16,6,0,0,
                     FW_NORMAL,0,0,0,ANSI_CHARSET,
                     OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                     DEFAULT_QUALITY, FIXED_PITCH bitOr FF_ROMAN,
                     asciiz("Tms Rmn"));
  tm := new(Struct, 32);
  hdc := getContext(self);
  oldFont := Call SelectObject(hdc,hFont);
  Call GetTextMetrics(hdc, tm);
  charWidth := asInt(wordAt(tm, 10));
  charHeight := asInt(wordAt(tm, 8)) + asInt(wordAt(tm, 0));
  if oldFont
    Call SelectObject(hdc,oldFont);
  endif;
  releaseContext(self, hdc);
}!!

/* PUBLIC
   Show self and all of the child windows.
 */
Def show(self, arg)
{ 
  show(self:WindowsObject, arg);
  show(levelWin,SW_NORMAL);
}!!

/* PRIVATE
   Place the push buttons at the top of the trigger window.
 */
Def sizeKids(self | startPos levelStart) {
  setCRect(levelWin,rect(0, nonScrollArea,
           461,(nonScrollArea + (charHeight*15) + (charHeight/2) + 2)));
  moveWindow(levelWin);
  invalidate(self);
}!!

Def sizeRect(self | rc offset ht wd)
{ offset := 0;
  ht := charHeight;
  if( not(ht) )
    ht := 16;  /* default height */
  endif;
  wd := charWidth;
  if( not(wd) )
    wd := 6;  /* default width */
  endif;
  if (x(screenSize()) > 800)
    rc :=rect(90, 40, (90 + (wd * 78) + (wd/3)), (40 + (ht*21)));
  else
    rc :=rect(90, 40, (90 + (wd * 78) + (wd/3)), (40 + (ht*20)));
  endif;
  ^rc;
}
!!

/* 9/21/1992 15:43 */
Def trigCounterMode(self)
{
  /* map micepack counter -> timer */
  /**186**
  if micepack?(ProcLibClass$Inst)
    ^trigTimerMode(self);
  endif;
  **186**/
  unCheckMenuItem(self,"Ti&mer");
  checkMenuItem(self,"&Counter");
  musicalBoxes(levelWin,TRIG_AS_COUNTER);
  invalidate(levelWin); 
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","counterTimer","counter");  
}
!!

/* PRIVATE
 */
Def trigEvent(self){ 
  showWaitCurs();
  if TheEventPresenter
  then 
    Call BringWindowToTop(getHWnd(TheEventPresenter)); 
    show( TheEventPresenter, SW_SHOWNORMAL ) ;
  else
    TheEventPresenter := open(EventWindow);
  endif;
  showOldCurs();
}
!!

/* PRIVATE
 */
Def trigExit(self)
{ 
  if (shouldClose(self))
  then
    close(self) ;
  else
    displayFormattedError(ErrorTextLibClass$Inst, 
       ER_INTERNAL, FORCE_POPUP, "File Exit Bug", 
       "shouldClose(self) said no", nil);
  endif ;
}
!!

/* PUBLIC */
Def trigger(self)
{ ^theTrigger }
!!

/* 6/1/1992 15:43 */
Def trigGoCounterMode(self){
  /* map micepack counter -> timer */
  /**186**
  if micepack?(ProcLibClass$Inst)
    ^trigGoTimerMode(self);
  endif;
  **186**/
  trigCounterMode(self);
  trigCounterFunctionSet( theTrigger, TRIG_AS_COUNTER) ;
  setupLevel(levelWin);
}
!!

/* 6/1/1992 15:43 */
Def trigGoTimerMode(self){ 
  trigTimerMode(self);
  trigCounterFunctionSet( theTrigger, TRIG_AS_TIMER) ;
  setupLevel(levelWin);
}
!!

/* 9/21/1992 15:43 */
Def trigTimerMode(self){
  /* only update menu entries if not micepack */
  if not(micepack?(ProcLibClass$Inst))
    unCheckMenuItem(self,"&Counter");
    checkMenuItem(self,"Ti&mer");
  endif;
  musicalBoxes(levelWin,TRIG_AS_TIMER);
  invalidate(levelWin); 
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","counterTimer","timer");  
}
!!

/* 6/1/1992 15:02 */
Def trigTraceConf(self | dlg){   
  dlg := new(TraceControlDialog);
  runModal(dlg, DLG_TRACECON, ThePort);
}!!

/* 6/1/1992 15:43 */
Def trigUseBusCycles(self)
{
  unCheckMenuItem(self,"C&lock");
  checkMenuItem(self,"&Bus");
  trigQualifierSet( theTrigger, QUALIFY_AS_BUS );
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","trigMode","bus");  
}
!!

/* 6/1/1992 15:43 */
Def trigUseClockCycles(self)
{
  /* map clock -> bus for micepack */
  if micepack?(ProcLibClass$Inst)
    ^trigUseBusCycles(self);
  endif;
  unCheckMenuItem(self,"&Bus");
  checkMenuItem(self,"C&lock");
  trigQualifierSet( theTrigger, QUALIFY_AS_CLOCK );
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","trigMode","clock");  
}
!!
