/****************************************************************************
**
**  Name:  fileutil.c
**
**  Description:
**     This is the source code to support line-based input from 
**     files that contain blank lines and // comment lines.
**
**  $Log:   S:/tbird/arcm332/cliulib/fileutil.c_v  $
** 
**    Rev 1.0   30 Sep 1993 16:24:10   ron
** Initial revision.
** 
**  $Header:   S:/tbird/arcm332/cliulib/fileutil.c_v   1.0   30 Sep 1993 16:24:10   ron  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VERSIONS_
#include "versions.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef __IO_H
#include <io.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#include "windows.h"
#include <string.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

const char WhiteSpace[] = " \t\r\n\b";

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/


/*--------------------------------------------------------------------------
**  ReadLine
**
**  Purpose:
**     Read a line (efficiently) from the open file (a replacement for
**     a function that read the file one byte at a time).
**
**  Input:
**     hFile:  The file handle.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT ReadLine(HFILE hFile, LPSTR buf, U16 bufsize)
{
   LPSTR lpNL;
   LPSTR lpCR;
   S32 lPos;
   U16 nChars;
   U8 nc;
   
   if (buf == NULL) return (ER_NO_MEM); /* most likely cause */
   lPos = tell(hFile);
   if(lPos < 0 || 
         (nChars = _lread(hFile, buf, bufsize)) <= 0) {
      return(ER_READING_FILE);
   }
   lpCR = _fstrchr((LPSTR)buf, (int) '\r');
   lpNL = _fstrchr((LPSTR)buf, (int) '\n');
   if (lpNL != NULL){
      nc = 1;
      *lpNL = '\0';

      /* CR not here in case we get files from Unix... */
      if (lpCR != NULL && lpCR + 1 == lpNL) { 
        *lpCR = '\0';
        nc++;
      }
      lPos += _fstrlen((LPSTR)buf) + nc;
      lseek(hFile, lPos, SEEK_SET);
   }
   else if (nChars < bufsize) {
     buf[nChars] = '\0'; /* make SURE it's null terminated */
   }
   return (GOOD);
}


/*--------------------------------------------------------------------------
**  FindLine
**
**  Purpose:
**     Find and return the next non-blank non-comment line (used by 
**     configuration file readers).
**
**  Input:
**     hFile:  The file handle.
**     line:   The line number in the file.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT FindLine(HFILE hFile, U16 FAR *line, LPSTR buf, U16 bufsize)
{
   LPSTR lpNonWhite = NULL;
   size_t l;
   RETCODE rval;

   while (1) {
     (*line)++;
     if((rval = ReadLine(hFile, buf, bufsize)) != GOOD) {
        return (rval);
     }
     l = _fstrspn(buf, (LPSTR)WhiteSpace);
     lpNonWhite = (LPSTR) &(buf[l]);
     // skip blank lines
     if (lpNonWhite[0] == '\0') continue;
     // skip comment lines
     if (_fstrnicmp(lpNonWhite, (LPSTR)"//", 2) == 0) continue;
     else break;
   }
   return (GOOD);
}
