/***************************************************************************
** Name:  ldtext86.c
**
** Desciption:  Text handling routines for ldasm.c
**
**
** Status:  PRELIMINARY
**
** $Log:   S:/tbird/arcm332/dasm/ldtext86.c_v  $
** 
**    Rev 1.2   05 Aug 1994 17:04:14   marilyn
** removed extraneous 0 in putdata routine for hex constants.
** 
**    Rev 1.1   01 Aug 1994 17:49:00   marilyn
** Changed db to DB.
** 
**    Rev 1.0   25 May 1994 14:18:40   nghia
** Initial revision.
**
** $Header:   S:/tbird/arcm332/dasm/ldtext86.c_v   1.2   05 Aug 1994 17:04:14   marilyn  $
** Copyright (C) 1994  Microtek International.  All rights reserved.
****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>
#include <string.h>

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _LDASM86_
#include "ldasm86.h"
#endif

#ifndef _LDTEXT86_
#include "ldtext86.h"
#endif

                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/
STATIC CHAR *BufPointer;
STATIC CHAR *TextBase;
STATIC CHAR *MemPointer;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/***************************************************************************
**
**  InitText
**
***************************************************************************/
RETCODE InitText(CHAR *Memdata, CHAR *TextBuffer)
{
   BufPointer = TextBuffer;
   TextBase = TextBuffer;
   MemPointer = Memdata;
   return(GOOD);
}

/***************************************************************************
**
**  PutText
**
***************************************************************************/
RETCODE PutText(U8 TextType, CHAR *Text)
{
   U16 SpaceLeft;
   CHAR TruncText[MAX_DASM_TEXT+1];

   if (!BufPointer) return(GOOD);             /* do nothing if NIL buffer */
   SpaceLeft = MAX_DASM_TEXT - (BufPointer - TextBase);
   if (SpaceLeft > lstrlen(Text)+1)
      switch(TextType) {
         case 0:
            BufPointer += sprintf(BufPointer,"@%s",Text) + 1;
            break;
         case 1:
            BufPointer += sprintf(BufPointer,"|%s",Text) + 1;
            break;
         default:
            BufPointer += sprintf(BufPointer,"%s",Text);
            break;
      }
   else {
      strncpy(TruncText,Text,SpaceLeft);
      switch(TextType) {
         case 0:
            BufPointer += sprintf(BufPointer,"@%s",TruncText) + 1;
            break;
         case 1:
            BufPointer += sprintf(BufPointer,"|%s",TruncText) + 1;
            break;
         default:
            BufPointer += sprintf(BufPointer,"%s",TruncText);
            break;
      }
   }
   return(GOOD);
}

/***************************************************************************
**
**  PutData
**
***************************************************************************/
RETCODE PutData(U8 Size, VOID *Code)
{
   U16 SpaceLeft;

   if (!BufPointer) return(GOOD);             /* do nothing if NIL buffer */
   SpaceLeft = MAX_DASM_TEXT - (BufPointer - TextBase);
   if (SpaceLeft > Size)
      switch (Size) {
         /*
         **  08/05/94 From Marilyn:  I am not exactly sure why this
         **  code was written to put the extra 0 in front of data
         **  bytes beginning with the A-F hex character.  I know that this
         **  is apparently an Intel standard, some of the assemblers
         **  for example will consider 0xFF or FF as an invalid constant.
         **  However, the PV assembler does accept FF as valid input
         **  and therefore by PV standards this is considered valid output.
         **  Therefore, the extraneous 0 is removed.
         */
         case NIBBLE_SIZE:
            BufPointer += sprintf(BufPointer,"%X",*((U8*)Code));
            break;
         case 1:
            BufPointer += sprintf(BufPointer,"%02X",*((U8*)Code));
/*
                       (*((U8*)Code)>0x9f)?"%03X":"%02X",*((U8*)Code));
*/
            break;
         case 2:
            BufPointer += sprintf(BufPointer,"%04X",*((U16*)Code));
/*
                     (*((U16*)Code)>0x9fff)?"%05X":"%04X",*((U16*)Code));
*/
            break;
         case 4:
            BufPointer += sprintf(BufPointer,"%05lX",*((U32*)Code));
/*
              (*((U32*)Code)>0x9fffffffL)?"%09lX":"%08lX",*((U32*)Code));
*/
            break;
      }
   return(GOOD);
}

/***************************************************************************
**
**  dbError
**
***************************************************************************/
RETCODE dbError(DASM_INFO *Info)
{

   if (!BufPointer) return(GOOD);             /* do nothing if NIL buffer */
   BufPointer = TextBase;
   PutText(OPCODE,"DB ");
   PutData(BYTE_SIZE,MemPointer);
   Info->bytesUsed = 1;
   return(GOOD);
}

/********************************* E O F **********************************/
