// main routine of symPool for testing it
#ifndef _CLISRV_
#include "clisrv.h"
#endif
#ifndef _LOAD_
#include "load.h"
#endif
#ifndef _MEMPOOL_
#include "mempool.h"
#endif
#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _INDEXTBL_
#include "indextbl.h"
#endif
#ifndef _SYMADD_
#include "symadd.h"
#endif
#ifndef _SYMMGR_
#include "symmgr.h"
#endif
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif
#ifndef _SYMCLIPR_
#include "symclipr.h"
#endif
#ifndef _SYMCLI_
#include "symcli.h"
#endif

#if !defined( __WINDOWS_H )
#include <windows.h>
#endif

#include "winio.h"

HANDLE cliServerHandle = 0;

void SymmgrTest(void);
void WinParse(void);

#define MAX_LOADS 50


void SymmgrTest(void) {

/*
   this test sets up several modules and symbols and attempts to verify
   that all of the various nesting and return functions works.
   The structure that is going to be set up is:
      
      root
         module1
            module2
               func1 <-> func2
                            unnamed block
         module3
*/

   LPSTR moduleName;
   BASE_INDEX baseIndex;
   LPSTR moduleReference;
   TIMESTAMP_TYPE timestamp;
   LOGICAL_ADDR_RANGE_TYPE codeAddrRange;
   
   LPSTR funcName;
   FUNC_CLASS funcClass;
   U32 stackSize;
   TYPE_INDEX typeIndex;
   
   SYM_DESCRIPTOR descriptor;
   VAR_STORAGE_CLASS storageClass;
   VAR_REGISTER_CLASS registerClass;
   
   RETCODE err;
   U16 i;


   moduleName="module1.c";
   baseIndex=0x0;
   moduleReference="c:/src/modules";
   timestamp.year=1991;
   timestamp.month=1;
   timestamp.day=1;
   timestamp.hour=12;
   timestamp.minute=0;
   timestamp.second=0;
   codeAddrRange.logicalStartAddr=0x5000L;
   codeAddrRange.logicalEndAddr=0x6000L;
   
   printf("Adding module %s\n",moduleName);
   if((err=SymAddModuleCreate(moduleName,baseIndex,moduleReference,
                      timestamp,codeAddrRange))!=GOOD) {
      printf("Adding the module %s failed\n",moduleName);
      return;
   }
   printf("%s added\n",moduleName);
   
   moduleName="module2.c";
   baseIndex=0x0;
   moduleReference="c:/src/modules";
   codeAddrRange.logicalStartAddr=0x4000L;
   codeAddrRange.logicalEndAddr=0x5000L;
   
   printf("Adding module %s\n",moduleName);
   if((err=SymAddModuleCreate(moduleName,baseIndex,moduleReference,
                      timestamp,codeAddrRange))==GOOD) {
   printf("%s added.  This shouldn't have happened.\n",moduleName);
      return;
   }
   printf("Adding the module %s failed\n",moduleName);
   
   funcName="func1.c";
   baseIndex=0x0;
   funcClass=FUNC_LOCAL;
   stackSize=0x100;
   codeAddrRange.logicalStartAddr=0x4000L;
   codeAddrRange.logicalEndAddr=0x4050L;
   typeIndex=1;

   printf("Adding function %s\n",funcName);
   if((err=SymAddFuncCreate(funcName,baseIndex,funcClass,stackSize,
                            codeAddrRange,typeIndex))!=GOOD) {
      printf("Adding the function %s failed\n",funcName);
      return;
   }
   printf("%s added\n",funcName);
   
   // now let's add some variables and some labels ;
   codeAddrRange.logicalStartAddr=4010L;
   codeAddrRange.logicalEndAddr=4011L;
   if((err=SymAddLabel((LPSTR)"Label1",0,codeAddrRange.logicalStartAddr))
      !=GOOD) {

      printf("Adding label: Label1 failed.\n");
      return;
   }
   printf("Label: Label1 added\n");

   // prove we create the linked list properly ;
   codeAddrRange.logicalStartAddr=4014L;
   codeAddrRange.logicalEndAddr=4015L;
   if((err=SymAddLabel((LPSTR)"Label2",0,codeAddrRange.logicalStartAddr))
      !=GOOD) {

      printf("Adding label: Label2 failed.\n");
      return;
   }
   printf("Label: Label2 added\n");
   
   // now add two variables
   storageClass=AUTO_VAR_CLASS;
   registerClass=NOT_REG;
   codeAddrRange.logicalStartAddr=4018L;
   codeAddrRange.logicalEndAddr=4019L;
   if((err=SymAddVar((LPSTR)"Var1",baseIndex,typeIndex,storageClass,
                     registerClass,&codeAddrRange,&descriptor))!=GOOD) {
      printf("Adding variable: Var1 failed\n");
      return;
   }
   printf("Added variable: Var1\n");

   funcName="Var2";
   codeAddrRange.logicalStartAddr=4030L;
   codeAddrRange.logicalEndAddr=4031L;
   if((err=SymAddVar((LPSTR)"Var2",baseIndex,typeIndex,storageClass,
                     registerClass,(VOID *)&codeAddrRange,&descriptor))!=GOOD) {
      printf("Adding variable: Var2 failed\n");
      return;
   }
   printf("Added variable: Var2\n");
   
   printf("Closing %s\n",funcName);
   if((err=SymAddFuncClose())!=GOOD) {
      printf("Closing %s FAILED!\n");
      return;
   }
   printf("%s closed\n",funcName);
   
   funcName="func2.c";
   baseIndex=0x0;
   funcClass=FUNC_LOCAL;
   stackSize=0x100;
   codeAddrRange.logicalStartAddr=0x4051L;
   codeAddrRange.logicalEndAddr=0x4090L;
   typeIndex=2;
   
   printf("Adding function %s\n",funcName);
   if((err=SymAddFuncCreate(funcName,baseIndex,funcClass,stackSize,
                            codeAddrRange,typeIndex))!=GOOD) {
      printf("Adding the function %s failed\n",funcName);
      return;
   }
   printf("%s added\n",funcName);
   
   printf("Adding unnamed block\n");
   if((err=SymAddBlockCreate(0x0))!=GOOD) {
      printf("Unnamed block creation failed\n");
      return;
   }
   printf("Unnamed block created\n");

   printf("Closing unnamed block\n");

   if((err=SymAddBlockClose())!=GOOD) {
      printf("Closing unnamed block failed\n");
      return;
   }
   printf("Closed unnamed block\n");

   printf("Closing %s\n",funcName);
   if((err=SymAddFuncClose())!=GOOD) {
      printf("Closing %s FAILED!\n",funcName);
      return;
   }
   printf("%s closed\n",funcName);

   // close module1.  module2 should never be opened ;
   moduleName="module1.c";
   printf("Closing %s \n",moduleName);
   if((err=SymAddModuleClose())!=GOOD) {
      printf("Closing %s FAILED!\n",moduleName);
      return;
   }
   printf("%s closed\n",moduleName);

   printf("All modules are closed\n");
   
   // add a new base here ;
   if((err=SymAddBaseCreate((LPSTR)"base1",1,12345678L,BASE_CODE))!=GOOD) {
      printf("Adding base: base1 failed.\n");
      return;
   }
   printf("Added base: base1\n");
   
   moduleName="module3.c";
   baseIndex=0x1;
   moduleReference="c:/src/modules";
   codeAddrRange.logicalStartAddr=0x7000L;
   codeAddrRange.logicalEndAddr=0x7100L;
   
   printf("Adding module %s\n",moduleName);
   if((err=SymAddModuleCreate(moduleName,baseIndex,moduleReference,
                      timestamp,codeAddrRange))!=GOOD) {
      printf("Adding the module %s failed\n",moduleName);
      return;
   }
   printf("%s added\n",moduleName);
   
   printf("Closing %s \n",moduleName);
   if((err=SymAddModuleClose())!=GOOD) {
      printf("Closing %s FAILED!\n",moduleName);
      return;
   }
   printf("%s closed\n",moduleName);

   printf("All modules are closed\n");
   
   
}     // end of SymTest

void WinParse(void) {
   unsigned char ch;

   do {
      printf("Enter 'l' to load c:\test.asc, or 'p' to print symbols\n");
      ch = getchar();
      printf("\n");

      if (ch=='l') { LoadAsciiFile((LPSTR)"c:/test.asc"); }
      if (ch=='p') {
         SymPrintSymbols((LPSTR)"dummy",1,NULL);
      }
   } while (1);
}

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
{

   unsigned vers = GetVersion();
   unsigned long flags = GetWinFlags();

   winio_settitle((BYTE *)"SYMMGR TEST");
   if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
      return(0);
   printf("Windows v. %d.%d\n", LOBYTE(vers), HIBYTE(vers));
   printf("%s mode\n",
      (flags & WF_ENHANCED) ? "Enhanced" :
      (flags & WF_STANDARD) ? "Standard" :
      /* default */           "Real");
   printf("%d tasks running\n", GetNumTasks());
   printf("%lu bytes of free global memory\n", GetFreeSpace(0));


//   InitCServer(hInstance,hPrevInstance);
//   SymmgrTest();
   WinParse();
   return(0);
};

/**************************************************************************
**
** InitCServer
**
***************************************************************************/
/*RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
   RETCODE err;
   if ((err = SymInitSymServer(cliHandle, dllHandle))!=GOOD) return(err);
/*   if( (err = SdatInitSharedDataServer(cliHandle, dllHandle)) != GOOD )
      return(err);*/
/*   return(GOOD);
} */
/******************************** E O F ***********************************/
