/****************************************************************************
**
**  Name:  hlpentry.h
**
**  Description: Help entry points for cases other than errors.  (Errors
**               have help entry points defined in the errtext server's
**               errhelp.h file.)
**
**  Status:  preliminary.
**
**  $Log:   S:/tbird/arcm332/inc/hlpentry.h_v  $
** 
**    Rev 1.11   14 Jul 1994 11:04:24   nghia
** Moved some help entries from Actor to Servers.
** Added RegisterHelpEntry() interface to this file.
** 
**    Rev 1.10   29 Jun 1994 09:30:46   marilyn
** Added help define for map which was moved from actor to c source.
** 
**    Rev 1.9   04 Jan 1994 15:19:06   tom
** Added actual help context numbers for PC-NFS changes.
** 
**    Rev 1.8   23 Dec 1993 09:32:00   tom
** New help context numbers for PC-NFS; bogus for now.
** 
**    Rev 1.7   27 Sep 1993 10:28:42   ron
** added defines for peripheral presenter dialogs
** 
**    Rev 1.6   01 Sep 1993 14:37:18   ron
** changes for help/menu support in Peripheral Presenter
** 
**    Rev 1.5   30 Aug 1993 11:04:46   ron
** changes for Load Progress dialog
** 
**    Rev 1.4   28 Jul 1993 19:56:26   ron
** put back for 2.0 build
** 
**    Rev 1.3   27 Jul 1993 15:57:08   ron
** made more specific help entry for delete all events (just goes to event
** window help, since there is no specific help for that dialog).
** 
**    Rev 1.2   22 Jul 1993 16:19:22   ron
** ppr 8378: needed entry for select compiler used dialog
** 
**    Rev 1.1   09 Jul 1993 16:37:30   ron
** added help entry index for F1 hook
** 
**    Rev 1.0   25 Jun 1993 13:43:20   ron
** Initial revision.
** 
**  $Header:   S:/tbird/arcm332/inc/hlpentry.h_v   1.11   14 Jul 1994 11:04:24   nghia  $
**
*****************************************************************************/
#ifndef _HLPENTRY_
#define _HLPENTRY_
                        /****************************
                         *                          *
                         *       INCLUDE FILES      *
                         *                          *
                         ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                        /****************************
                         *                          *
                         *        DEFINITIONS       *
                         *                          *
                         ****************************/


/*
 * HELP ENTRY POINTS
 */
#define IDHELP 8

/*
 * Table of contents really is id 1...
 */
#define HE_CONTENTS                     1
#define HE_DLGR_LOAD_FILE               2013 /* loadcodedialog */
#define HE_DLGR_LOAD_OPTIONS            2014 /* loadoptionsdialog */
#define HE_DLGR_LOAD_MODULE             2004 /* browsemodulesdialog */
#define HE_DELETE_ALL_EVENTS            2037
#define HE_LOADER_INFO                  1
#define HE_ENLIB_DEBUG_QUERY_1          1
#define HE_ENLIB_DEBUG_QUERY_2          1
#define HE_ENLIB_DEBUG_QUERY_3          1
#define HE_SDS_WSNET_1                  1
#define HE_SDS_WSCOM_1                  2048
#define HE_SELECT_COMPILER_DIALOG       2049

#define HE_INTERNAL_ERROR               13

#define HE_CANCEL_LOAD                  2059
#define HE_LOAD_PROGRESS                2060
#define HE_LOAD_INFO                    2061
#define HE_DLGM_SRCPATH_CHANGED         2063 /* newchangeswarning */
#define HE_DLGF_ADD_SRC_PATH            2064 /* pathtosourcedialog */
#define HE_DLGD_SRCPATHD                2065 /* editpathdialog */

#define HE_PERIPHERAL                   2067
#define HE_EDITPERIPHREGBUFFER          2068
#define HE_EDITPERIPHREG                2069
#define HE_PERIPHGOTOADDRESS            2070
#define HE_PERIPHGOTOPERIPH             2071

#define HE_NET_EMULATOR_BUSY            2072
#define HE_HOST_SELECTION_DLG           2073

#define HE_MAP                          2015   /* mapdialogbox */

/*
 * Index of F1 hook table entry (see cliulib\f1hook.c)
 */

#define HI_MESSAGEBOXEX         21
#define HI_DLGR_LOAD_FILE       24 /* loadcodedialog */
#define HI_DLGR_LOAD_OPTIONS    25 /* loadoptionsdialog */
#define HI_DLGD_SRCPATHD        35 /* sourcepathsdialog */
#define HI_FILE_DLG             37
#define HI_PERIPHERAL           39

            
/* NOTES: Nghia - 06/30/94
** Each HI_xxxxx must be a unique number and < MAXENTRIES.
** Whenever adding a new HI_xxxxx entry, Please check and make sure that
** the new entry is not used by /actor/res/hlpentry.h
*/
#define MAXENTRIES 45
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif
           
/****************************************************************************
**
**  RegisterHelpEntry
**
**  Purpose:
**    Record the Window Handle of a PowerViews window or dialog along with
**    the help entry to use for it.
**
**  Input:
**     hInd:       The index in the handle/entry array for this window.
**                 HI_xxxxx 
**     hWnd:       The parent window handle.
**     helpEntry:  The help entry to use if F1 is pressed over that window.
**
**  Output:
**     None.
*****************************************************************************/
RETCODE EXPORT RegisterHelpEntry(U16 hInd, LONG hWndTmp, WORD helpEntry);
           
#ifdef __cplusplus
}
#endif

#endif /* _HLPENTRY_ */
/********************************** EOF *************************************/
