/*****************************************************************************
**
**    Name:    swat.h
** 
**    Description: 
**       PA and CA server external interface
**
**    Status: PRELIMINARY
**
**    $Log:   S:/tbird/arccore/inc/swat.h_v  $
** 
**    Rev 1.3   30 Apr 1993 15:59:36   ernie
** Added SwatCaClear, SwatPaCleat, SwatSetRun, and SwatGetRun functions.
** 
**    Rev 1.2   28 Apr 1992 08:08:26   mindy
** opens now get a template name not an event id
** 
**    Rev 1.1   25 Jan 1992 12:51:22   courtney
** This file was archived in two places, in \tbird\core\trace as as well
** as in \tbird\core\inc.  I've tried to keep the current source changes
** from \trace, but archive the file in a single place, \inc.
** 
**    Rev 1.2   06 Dec 1991 10:40:12   mindy
** made changes needed to combine with trace
** 
**    Rev 1.1   27 Nov 1991 12:32:42   ernie
** 1. Added timestamp functions.
** 2. Cosmetic changes to pa, ca functions.
** 
**    Rev 1.0   21 Nov 1991 14:03:00   ernie
** Initial revision.
**  
**    $Header:   S:/tbird/arccore/inc/swat.h_v   1.3   30 Apr 1993 15:59:36   ernie  $
**
*****************************************************************************/

#define _SWAT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef enum {
   CA_REGION0, CA_REGION1, CA_REGION2, CA_REGION3
} CA_REGION;

typedef enum {
   PA_BIN0, PA_BIN1, PA_BIN2, PA_BIN3
} PA_BIN;

typedef enum { SWAT_CLOCKS, SWAT_TIME } SWAT_UNIT;

typedef struct {
   U32 count;            /* number of times procedure is entered or exited */
   double minDuration;   /* minimum duration of procedure */
   double maxDuration;   /* maximum duration of procedure */
   double aveDuration;   /* average duration of procedure */
   U32 proportion;       /* proportion of total time spent in procedure:
                               fixed point (0x10000 indicates 100%) */
} PA_RESULT;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*****************************************************************************
** 
**    SwatInitSwatServerCli
** 
**    Description:
**       Registers the swat server's routines with the CLI server.
** 
**    Parameters:
**       input:
**          cliHandle:  registration target for servers.
**          dllHandle:  handle to use in messages to tag this DLL.
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatInitSwatServerCli(HANDLE cliHandle, HANDLE dllHandle);

/*****************************************************************************
** 
**    SwatInitSwatServer
** 
**    Description:
**       Does initialization for swat server.
** 
**    Parameters:
**       input:
**          none
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatInitSwatServer(VOID);
      
/*****************************************************************************
** 
**    SwatOpenCa
** 
**    Description:
**       Creates and returns a descriptor for a coverage swat session
** 
**    Parameters:
**       input:
**          templateName:     name of which template to use.
**       output:
**          desc:             opaque descriptor
**
*****************************************************************************/
RETCODE EXPORT SwatOpenCa(DESCRIPTOR FAR *desc, LPSTR templateName);
      
/*****************************************************************************
** 
**    SwatOpenPa
** 
**    Description:
**       Creates and returns a descriptor for a perf analysis swat session
** 
**    Parameters:
**       input:
**          templateName:     name of which template to use.
**       output:
**          desc:             opaque descriptor
**
*****************************************************************************/
RETCODE EXPORT SwatOpenPa(DESCRIPTOR FAR *desc, LPSTR templateName);
      
/*****************************************************************************
** 
**    SwatOpenTs
** 
**    Description:
**       Creates and returns a descriptor for a timestamp swat session
** 
**    Parameters:
**       input:
**
**       output:
**          desc  opaque descriptor
**
*****************************************************************************/
RETCODE EXPORT SwatOpenTs(DESCRIPTOR FAR *desc);
      
/*****************************************************************************
** 
**    SwatClose
** 
**    Description:
**       Destroys a swat session descriptor.  Must not be the currently
**       active swat descriptor.
** 
**    Parameters:
**       input:
**          desc  opaque descriptor
**
**       output:
**
*****************************************************************************/
RETCODE EXPORT SwatClose(DESCRIPTOR desc);
      
/*****************************************************************************
** 
**    SwatSetActive
** 
**    Description:
**       Configures swat hardware collection into the mode described by desc.
** 
**    Parameters:
**       input:
**          desc  opaque descriptor (or NULL to stop swat collection)
**
**       output:
**
*****************************************************************************/
RETCODE EXPORT SwatSetActive(DESCRIPTOR desc);
      
/*****************************************************************************
** 
**    SwatGetActive
** 
**    Description:
**       Returns currently active swat descriptor
** 
**    Parameters:
**       input:
**
**       output:
**          desc  opaque descriptor (or NULL if swat collection is stopped)
**
*****************************************************************************/
RETCODE EXPORT SwatGetActive(DESCRIPTOR FAR *desc);
      
/*****************************************************************************
** 
**    SwatSetRun
**    SwatGetRun
** 
**    Description:
**       Starts and stops swat collection.  The supplied descriptor must
**       be the currently Active swat descriptor (use SwatSetActive).
** 
**    Parameters:
**       input:
**          desc  opaque descriptor (or NULL to stop swat collection)
**
**       output:
**
*****************************************************************************/
RETCODE EXPORT SwatSetRun(DESCRIPTOR desc, BOOLEAN run);
RETCODE EXPORT SwatGetRun(DESCRIPTOR desc, BOOLEAN *run);
      
/*****************************************************************************
** 
**    SwatSetCaRegionBase
** 
**    Description:
**       Sets base of coverage analysis region in physical memory.
**       Uses current setting of "SetCurrentRegion".
** 
**    Parameters:
**       input:
**          desc      opaque descriptor
**          base:     new base (physical offset)
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetCaRegionBase(DESCRIPTOR desc, U32 base);
      
/*****************************************************************************
** 
**    SwatGetCaRegionBase
** 
**    Description:
**       Returns base of coverage analysis region in physical memory.
**       Uses current setting of "SetCurrentRegion".
** 
**    Parameters:
**       input:
**          desc:     opaque descriptor
**
**       output:
**          base:     new base
**
*****************************************************************************/
RETCODE EXPORT SwatGetCaRegionBase(DESCRIPTOR desc, U32 FAR *base);
      
/*****************************************************************************
** 
**    SwatSetCaQualifyEvent
** 
**    Description:
**       Sets event name for qualifiying ca samples.
** 
**    Parameters:
**       input:
**          desc:    opaque descriptor
**          event:   new qualify event name (NULL terminated string)
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetCaQualifyEvent(DESCRIPTOR desc, LPSTR event);
      
/*****************************************************************************
** 
**    SwatGetCaQualifyEvent
** 
**    Description:
**       Returns current qualify event name
** 
**    Parameters:
**       input:
**          desc:     opaque descriptor
**          event:    pointer to memory to recieve event name string
**          size:     size in bytes of caller's memory
**
**       output:
**          event:    caller's memory filled with event name string
**
*****************************************************************************/
RETCODE EXPORT SwatGetCaQualifyEvent(DESCRIPTOR desc, LPSTR event, U16 size);
      
/*****************************************************************************
** 
**    SwatSetCaCurrentRegion
** 
**    Description:
**       Sets default region for obtaining results
** 
**    Parameters:
**       input:
**          desc:      opaque descriptor
**          region:    default region
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetCaCurrentRegion(DESCRIPTOR desc, CA_REGION region);
      
/*****************************************************************************
** 
**    SwatGetCaCurrentRegion
** 
**    Description:
**       Returns current default region
** 
**    Parameters:
**       input:
**          desc:       opaque descriptor
**
**       output:
**          region:     current default region
**
*****************************************************************************/
RETCODE EXPORT SwatGetCaCurrentRegion(DESCRIPTOR desc,CA_REGION FAR *region);
      
/*****************************************************************************
** 
**    SwatCaResultInit
** 
**    Description:
**       This call initializes the module listbox.
**       The current module is set to the first (as reported by symbol table).
**       The current function is set to the first in the module.
**       The current statement is set to the first in the function.
**       The module, function, and statement listboxes are updated.
**       The current window handles are set to the window handle parameters.
** 
**    Parameters:
**       input:
**          desc:          descriptor
**          hWndModule:    window handle of module listbox
**          hWndFunction:  window handle of function listbox
**          hWndStatement: window handle of statement listbox
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatCaResultInit(DESCRIPTOR desc, HWND hWndModule,
                                HWND hWndFunction, HWND hWndStatement);
      
/*****************************************************************************
** 
**    SwatSetCaModule
** 
**    Description:
**       Notifies server that a new module selection was made in listbox.
**       The current function is set to the first in the new module.
**       The current statement is set to the first in the new function.
**       The function and statement listboxes are updated.  The current
**       module, function and statement listbox window handles are used.
** 
**    Parameters:
**       input:
**          desc:          descriptor
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetCaModule(DESCRIPTOR desc);
      
/*****************************************************************************
** 
**    SwatSetCaFunction
** 
**    Description:
**       Notifies server that a new function selection was made in listbox.
**       The current statement is set to the first in the new function.
**       The statement listbox is updated. The current function and statement
**       listbox window handles are used.
** 
**    Parameters:
**       input:
**          desc:          descriptor
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetCaFunction(DESCRIPTOR desc);

/*****************************************************************************
** 
**    SwatCaClear
** 
**    Description:
**       Clear ca coverage memory
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatCaClear(DESCRIPTOR desc);

      
/*****************************************************************************
** 
**    SwatSetPaCurrentBin
** 
**    Description:
**       Sets current pa bin number.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          bin:    bin number
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetPaCurrentBin(DESCRIPTOR desc, PA_BIN bin);

/*****************************************************************************
** 
**    SwatGetPaCurrentBin
** 
**    Description:
**       Returns current pa bin number.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          bin:    bin number
**
*****************************************************************************/
RETCODE EXPORT SwatGetPaCurrentBin(DESCRIPTOR desc, PA_BIN FAR *bin);

/*****************************************************************************
** 
**    SwatSetPaStartEvent
** 
**    Description:
**       Sets event used for defining the start of a pa bin.  Uses setting
**       of CurrentBin.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          event:  name of event
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetPaStartEvent(DESCRIPTOR desc, LPSTR event);

/*****************************************************************************
** 
**    SwatGetPaStartEvent
** 
**    Description:
**       Returns event used for defining pa bins.  Uses setting of CurrentBin.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor.
**          event:  pointer to caller's memory
**          size:   size in bytes of caller's memory
**
**       output:
**          event:  name of event is filled into caller's memory
**
*****************************************************************************/
RETCODE EXPORT SwatGetPaStartEvent(DESCRIPTOR desc, LPSTR event, U16 size);
      
/*****************************************************************************
** 
**    SwatSetPaStopEvent
** 
**    Description:
**       Sets event used for defining the stop of a pa bin.  Uses setting of
**       CurrentBin.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          event:  name of event
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetPaStopEvent(DESCRIPTOR desc, LPSTR event);

/*****************************************************************************
** 
**    SwatGetPaStopEvent
** 
**    Description:
**       Returns event used for defining pa bin.  Uses setting of CurrentBin.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor.
**          event:  pointer to caller's memory
**          size:   size in bytes of caller's memory
**
**       output:
**          event:  name of event is filled into caller's memory
**
*****************************************************************************/
RETCODE EXPORT SwatGetPaStopEvent(DESCRIPTOR desc, LPSTR event, U16 size);
      
/*****************************************************************************
** 
**    SwatSetPaUnit
** 
**    Description:
**       Sets units to use when returning pa results
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          unit:   unit to use when returning pa results
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetPaUnit(DESCRIPTOR desc, SWAT_UNIT unit);

/*****************************************************************************
** 
**    SwatGetPaUnit
** 
**    Description:
**       Returns units to use when returning pa results
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          unit:   unit to use when returning pa results
**
*****************************************************************************/
RETCODE EXPORT SwatGetPaUnit(DESCRIPTOR desc, SWAT_UNIT FAR *unit);

/*****************************************************************************
** 
**    SwatGetPaResult
** 
**    Description:
**       Returns pa result for CurrentBin.
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          result: pa result is filled into user's memory.
**
*****************************************************************************/
RETCODE EXPORT SwatGetPaResult(DESCRIPTOR desc, PA_RESULT FAR *result);
      
/*****************************************************************************
** 
**    SwatPaClear
** 
**    Description:
**       Clear pa accumulators; set all bins to inactive state
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatPaClear(DESCRIPTOR desc);

/*****************************************************************************
** 
**    SwatSetTsUnit
** 
**    Description:
**       Sets units to use when returning ts results
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          unit:   unit to use when returning ts results
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT SwatSetTsUnit(DESCRIPTOR desc, SWAT_UNIT unit);

/*****************************************************************************
** 
**    SwatGetTsUnit
** 
**    Description:
**       Returns units to use when returning ts results
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**
**       output:
**          unit:   unit to use when returning ts results
**
*****************************************************************************/
RETCODE EXPORT SwatGetTsUnit(DESCRIPTOR desc, SWAT_UNIT FAR *unit);

/*****************************************************************************
** 
**    SwatGetTimestamp
** 
**    Description:
**       Returns timestamp for a frame.  Returned by writing string to
**       user memory (e.g. "12:37:23.887.567.350")
** 
**    Parameters:
**       input:
**          desc:   opaque descriptor
**          frame:  physical trace frame number
**          result: pointer to user's memory to receive result.
**          size:   size of user's memory
**
**       output:
**          result: ts result filled into user's memory.
**
*****************************************************************************/
RETCODE EXPORT SwatGetTimestamp(DESCRIPTOR desc, U32 frame, LPSTR result,
                                U16 size);

/*****************************************************************************
** 
**    SwatGetTimestampDisplayLength
** 
**    Description:
**       Returns the number of character positions the timestamp field
**       needs to display itself.
**
**    Parameters:
**       input:
**          id:               descriptor for timestamp
**       output:
**          length:           number of character positions field needs 
**
*****************************************************************************/
RETCODE EXPORT SwatGetTimestampDisplayLength(DESCRIPTOR id, U8 FAR *length);

                             
/*********************************** E O F **********************************/
