/****************************************************************************
**
**  Name:  ldrdlgs.h
**
**  Description:
**     Declaration of functions and dialog box resource ID to be used in
**     Loader dialog boxes.
**     This file is used by both the source and resource files.
**
**  $Log:   S:/tbird/arcm332/loader/ldrdlgs.h_v  $
** 
**    Rev 1.4   12 Oct 1994 09:20:56   nghia
** Defined separate load option id for OMF86 and default dialogs.
** 
**    Rev 1.3   11 Oct 1994 11:40:42   nghia
** Added LdrValidateSelFile() to validate the load format of the supported
** load formats (IEEE695, OMFx, SREC, etc.).
** 
**    Rev 1.2   11 Oct 1994 10:24:28   nghia
** Revised LdrOpenLoadOptionsDlg() to use a paramterized resourceId.
** 
**    Rev 1.1   30 Aug 1994 17:20:26   nghia
** Added CHECKBX_REGISTERS to support new load option for Intel processors.
** 
**    Rev 1.0   14 Jul 1994 10:51:26   nghia
** Initial revision.
**
**  $Header:   S:/tbird/arcm332/loader/ldrdlgs.h_v   1.4   12 Oct 1994 09:20:56   nghia  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LDRDLGS__
#define __LDRDLGS__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef RC_INCLUDE

#ifndef _WCOMMDLG_
#include "wcommdlg.h"
#endif

#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
//---------------------------------------------------------------------------
// Customized LoadFile dialog box
#define LOADFILE_DLG     101
#define ID_OPTIONS       1039

#define SOURCE_PATH_DLG  102 
#define CHECKBX_ADD      1039

// Load Options dialog
#define LOPTIONS_DEFAULT_DLG  103
#define LOPTIONS_MOTO_DLG     104
#define LOPTIONS_INTEL386_DLG 105
#define LOPTIONS_INTEL86_DLG  106

// Load Options Id and CheckBox control
//
#define LOADFLAG(x) (0x0FFF & x)


// CheckBox Id
// NOTES: these ID match the Load Flag bit in LOADER.H
#define CHECKBX_CODE             0x1001
#define CHECKBX_SYMBOL           0x1002
#define CHECKBX_ONDEMAND         0x1004
#define CHECKBX_ASMMODULE        0x1008
#define CHECKBX_STATUS           0x1010
#define CHECKBX_WARNING          0x1020
#define CHECKBX_DEMANGLE         0x1040
#define CHECKBX_UPDATEBASE       0x1080
#define CHECKBX_REGISTERS        0x1400 

#define BUTTON_SPACE_USER        2000
#define BUTTON_SPACE_SMM         2001 

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifndef RC_INCLUDE
// don't include in RC

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
**
**  LdrOpenLoadFileDlg
**
**  Description:
**     Function to open a customized FILEOPEN dialog box for user to select
**     a new loadfile, or set load options.
**
**  Parameters:
**     parent:        parent Windows handle.
**     initDir:       initial directory where the FILEOPEN will locate.
**     loadFileName:  new loadfile name.
**     loadFlags:     new load options.
**     addrSpace:     load address space.
**
******************************************************************************/
RETCODE LdrOpenLoadFileDlg(HWND parent, LPSTR initDir, LPSTR loadFileName,
                           U32 *loadFlags, ADDR_SPACE *addrSpace);

/*****************************************************************************
**
**  LdrLoadFileDlgHookProc
**
**  Description:
**     Customized verion of the hook function to handle additional.
**     controls in the LoadFile dialog box.
**
**  Parameters:
**     none (standard Windows Proc paramaters)
**     
******************************************************************************/
UINT CALLBACK LdrLoadFileDlgHookProc(HWND hDlg, UINT msg, WPARAM wP,
                                      LPARAM lP);

/*****************************************************************************
**
**  LdrOpenLoadOptionsDlg
**
**  Description:
**     Function to open the LoadOptions dialog box.
**
**  Parameters:
**     parentHwnd:     parent Windows Handle.
**     loadOptions:    pointer to current load options settings.
**     addrSpace:      pointer to load address space.
**     resourceId:     Id of the LoadOptions dialog resource.
**
******************************************************************************/
RETCODE EXPORT LdrOpenLoadOptionsDlg(HWND parentHwnd, U32 FAR *loadOptions,
                                     ADDR_SPACE FAR *addrSpace,
                                     U16 resourceId);


/*****************************************************************************
**
**  LdrOptionsDlgProc
**
**  Description:
**     Function to handle dialog box processing for the Load Options dialog
**     box.
**
**  Parameters:
**     none (standard Windows proc parameters).
**
******************************************************************************/
BOOL FAR PASCAL LdrOptionsDlgProc(HWND hDlg, WORD iMsg, WORD wParam,
                                  LONG lParam);

/*****************************************************************************
**
** LdrValidateSelFile
**
** Description: Validate the input selected loadfile for the LdrLoadFileDlg.
** Although this function is an EXPORT function. It is used PRIVATE only.
** 
** Parameters:
**    input:
**       hDlg:             - Handle of the LoadFile dialog
**       *loadOptionsRscId - The Load Options resource Id.
**
******************************************************************************/
RETCODE EXPORT LdrValidateSelFile(HWND hDlg, U16 FAR *lOptionsRscId);

#ifdef __cplusplus
}
#endif

#endif /* RC_INCLUDE */

#endif /* __LDRDLGS__ */
/******************************** E O F *************************************/
