/****************************************************************************
**
**  Name:  BASE.H
**
**  Description:
**      Header file used by BASE.CPP
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm332/omf86/base.h_v  $
** 
**    Rev 1.9   07 Apr 1995 09:19:32   nghia
** Revised BASE modules to support 32K segments.
** Defined SEGDEF and LNAMES as C++ classes to be used as objects stored in
** the dynamic array template DArray<X>.
** Moved base's related functions from OMF86 module to BASE module for 
** locality.
** Defined new max limits for number of SEGDEF and LNAMES records that the
** OMF86 can hold.
** 
**    Rev 1.8   06 Sep 1994 09:52:06   joyce
** Change the size of base name buffer.
** 
**    Rev 1.7   22 Aug 1994 20:37:42   JOYCE
** 1. Add base type and base type name related information.
** 2. Add new prototype GetBaseTypeName().
**
**    Rev 1.5   14 Jul 1994 15:23:12   steve
** More changes for 386 build 8 from Joyce
**
**    Rev 1.2   02 Jun 1994 18:49:16   joyce
** Remove NULL_STR
**
**    Rev 1.1   25 May 1994 16:15:22   joyce
** Add the DestroyName(VOID) prototype.
**
**    Rev 1.0   24 May 1994 14:47:56   joyce
** Initial revision.
**
**  $Header:   S:/tbird/arcm332/omf86/base.h_v   1.9   07 Apr 1995 09:19:32   nghia  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __BASE__
#define __BASE__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HEAP_
#include "heap.h"       // provide TMalloc & TFree
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAX_SEGMENTS 32767
#define MAX_NAMES    32767

#define DEFAULT_MAX_SEGMENTS 2048
#define DEFAULT_MAX_NAMES    1024
#define DEFAULT_GROW_SIZE    512
#define CACHE_SIZE   20
#define BASE_NAME_LEN 32

// Appliation and Key names in PWRVIEWS.INI for OMF86 loader
#define TOOL_CHAIN     "ToolChain"
#define OMF_BASE_TYPE  "OMFBaseTypeNames"
#define DELIMITER_SET ","
#define MAX_BASE_TYPE_NAMES 2

typedef struct {
   U16 segFrame;
   U8  segOffset;                               /* value between 0 and 15 */
   U16 segLength;
} SEG_DATA;

typedef struct {
   BASE_ADDRESS  baseAddr;
   SEG_ADDR_SPACE addrSpace;
   U16  baseIndex;
   BASE_TYPE baseType;
} BASE_CACHE;

typedef struct {
   BOOLEAN baseKnown;
   U16  baseAddr;
   U16  baseIndex;
   BASE_TYPE baseType;
} MODULE_BASE;


// Class LNAMES - Object to hold LNAME records.
class LNAMES { 
public:
   static RETCODE LastError;  // last operation error
   LPSTR nameStr;

   // CTor & DTor
   LNAMES();
   LNAMES(LPSTR iStr);
   ~LNAMES();

   // member access function
   LPSTR Name() { return nameStr; } 
};

// Class SEGDEF - Object to hold SEGDEF records.
class SEGDEF {
public:   
   static RETCODE LastError; // last operation error

   U16       nameId;      // segment name id - index into LNAMES::NamesList[]
   U16       baseIndex;   // segment base id
   U16       frame;
   U16       offset;
   U16       size;        // segment size
   BASE_TYPE baseType;    // segment type: CODE, DATA, ... 

   // Ctor & Dtor
   SEGDEF(VOID); // dummy constructor 
   SEGDEF(U16 segNameId, U16 segId, SEG_DATA& segData, BASE_TYPE baseType);
   ~SEGDEF(VOID);

   // member functions to handle accessing
   const LPSTR SegName(); 
   BASE_TYPE SegBaseType() { return baseType; }
   U16 SegFrame() { return frame; }
   U16 SegOffset() { return offset; }
  
   // Allocator & Deallocator
   VOID* operator new(size_t sizeObj) { return TMalloc((U32) sizeObj); }
   VOID operator delete(VOID* p) { if (p) TFree((LPSTR) p); }

	// Global functions
	static RETCODE FindSegment(BASE_ADDRESS segment, SEGDEF** segPtr);
};

typedef LNAMES* LNAMESPTR;
typedef SEGDEF* SEGDEFPTR;

                       /****************************
                        *                          *
                        *     PROTOTYPES           *
                        *                          *
                        ****************************/

/* Base Function Interfaces */
RETCODE DestroyNames(VOID);
RETCODE ProcessLNAMES(OMF86_FUNC_PARA *);
RETCODE DestroySegDefs(VOID);
RETCODE ProcessSEGDEF(OMF86_FUNC_PARA *);
RETCODE FreeSections(VOID);
RETCODE GetBaseIndex(BASE_ADDRESS, SEG_ADDR_SPACE, BOOLEAN,
                     BASE_INDEX*, BASE_TYPE*);
RETCODE GetName(HANDLE, U8 *, CHAR*);
RETCODE GetBaseTypeNames(VOID);
RETCODE GetPhysicaBase(HANDLE, LADDRESS*);
RETCODE GetBaseOffset(HANDLE, LADDRESS*);
RETCODE GetIndex(HANDLE, U16*);

#endif /* __BASE__ */
/******************************** E O F ***********************************/
