/****************************************************************************
**
**  Name:  OMF86LDR.H
**
**  Description:
**      Major header file used by OMF86 Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm332/omf86/omf86ldr.h_v  $
** 
**    Rev 1.12   10 Mar 1995 13:49:52   nghia
** Revised #define to enum types: BLOCK_STATES and PROCESS_MODULE.
** These enum types will give better debug information.
** 
**    Rev 1.11   11 Oct 1994 10:11:34   joyce
** Add block state definitions.
**
**    Rev 1.10   20 Sep 1994 11:59:24   joyce
** Add a module -- regtbl.obj.
**
**    Rev 1.9   06 Sep 1994 10:00:06   joyce
** Change the size of NAME_LEN to 255 to support the maximum allowed string
** length for OMF86 format.
**
**    Rev 1.8   22 Aug 1994 20:35:54   JOYCE
** Change the point-to-next pointer to FAR in struct. PUBLIC_SYM and DEBUG_SYM.
**
**    Rev 1.6   25 Jul 1994 15:19:24   steve
** Added DEBUG_SYM type for DEBUG.CPP. - Updated for build 9.
**
**    Rev 1.5   14 Jul 1994 15:18:30   steve
** Joyce's omf86 changes for 386 build 8
**
**    Rev 1.3   17 Jun 1994 15:17:24   joyce
** Flush() now returns a value, so its prototype is changed.
**
**    Rev 1.2   16 Jun 1994 13:41:52   joyce
** Add QOK and QCANCEL definitions for function Query() in OMF86.CPP.
**
**    Rev 1.1   02 Jun 1994 18:50:32   joyce
** 1. Move DoNothing(), UnknownRecord() and PassAtPhaseI() to OMF86.CPP.
** 2. Change the return type of OMFGetBytes() from S16 to RETCODE; change
** 3. Add prototype for SkipOver().
**
**    Rev 1.0   24 May 1994 14:48:38   joyce
** Initial revision.
**
**  $Header:   S:/tbird/arcm332/omf86/omf86ldr.h_v   1.12   10 Mar 1995 13:49:52   nghia  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __OMF86LDR__
#define __OMF86LDR__

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

#ifndef _LQUEUE_
#include "lqueue.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

// File read buffer size for loader
#define LDR_BUFSIZE  4096
#define SEGMENT_OFFSET_LEN 10  // xxxx:xxxx
#define BUFSIZE 128
#define NAME_LEN 255
#define PUBLIC_PREFIX '_'

#define LARGE_INDEX(index)  (index & 0x80)
#define HAS_STARTADDR(flags)   (flags & 0x1)

/* returns from _Query */
#define QOK         0
#define QCANCEL     1

// initial value for pushback ch
// #define INITIAL_CH      0xff

/* How to process a module */
typedef enum {
   MCREATE = 0,       /* create entry in symbol table */
   MOPEN   = 1       /* re-open (has already been created) - used */
} PROCESS_MODULE;

/* Used by REGTBL.CPP */
#define MAX_REGISTER_SUPPORTED 30
#define MAX_LINE 128

// OMF86 record range and record signatures
#define MIN_TYPE_REC   0x6E // RHEADR
#define MAX_TYPE_REC   0xAA // LIBDIC
#define BLKDEF         0x7A // BLKDEF
#define BLKEND         0x7C // BLKEND
#define THEADR         0x80 // THEADR
#define MODEND         0x8A // MODEND
#define TYPDEF         0x8E // TYPDEF
#define PUBDEF         0x90 // PUBDEF

// variable types
#define PUBLICSYM       1       /* variable is not limited in scope */
#define LOCALSYM        2       /* variable is scoped by block names */
#define STATICSYM       4       /* variable not stack resident */
#define AUTOMATICSYM    8       /* stack resident variable */
#define GLOBALSYM      16       /* variable is scoped by module names */

// function type attribute
#define FUNC_ATTRIB_NEAR 0
#define FUNC_ATTRIB_FAR  1

// Block states
typedef enum {
   BLOCK_END = 0, BLOCK_START = 1, BLOCK_DISCARD = 0xFF
} BLOCK_STATES;

#define BLOCK_STATE_SIZE    32

// OMF86 record header
typedef struct {
   U8 type;
   U16 len;
} OMF86_REC_HEADER;

// OMF86 record header
typedef struct {
   HANDLE hFile;
   U32 endLoc;
   U32 flags;
   PROCESS_MODULE oFlag;
   SEG_ADDR_SPACE addrSpace;
   SYM_DESCRIPTOR moduleDesc;
} OMF86_FUNC_PARA;

// OMF86 record information
typedef struct {
   CHAR *name;
   RETCODE (*proc)(OMF86_FUNC_PARA *para);
   U32 count;
} OMF86_REC_TYPE_INFO;

typedef struct {
   U8 lFlag:1;
   U8 :5;
   U8 regId:2;
} REGTYP;

typedef struct {
   U16 segment;
   U16 offset;
} LADDRESS;

typedef struct {
   U16 frameNum;
   U8  offset;
} PHY_BASE;

typedef struct {
   U16 rptCnt;
   U16 blkCnt;
   U8  byteCnt;
   U8  content[1];
} ITER_DATA;

typedef struct {
   U8 pageResident:1;        /* least significant bit comes first */
   U8 big:1;
   U8 combination:3;
   U8 alignment:3;
} ACBP;                 /* microsoft extension allows this to be one byte */

typedef struct {
   U8 lFlag:1;
   U8 :5;
   U8 mAttr:2;
} MOD_TYP;

typedef struct {
   U16   lineNum;
   U16   offset;
} LINENUM_ENTRY;

typedef struct {
   U8 frameMethod:3;
   U8 :3;
   U8 lFlag:1;
   U8 based:1;
} FRAME_INFO;

typedef struct {
   U16 blkOffset;
   U16 blkSize;
} BLOCK_INFO;

typedef struct {
   U8 :6;
   U8 longBit:1;
   U8 procBit:1;
} PROC_INFO;

typedef struct public_sym {
   BOOLEAN isLoaded;
   LADDRESS addr;
   CHAR *symName;
   TYPE_INDEX typeIndex;
   struct public_sym FAR *next;
} PUBLIC_SYM;

typedef struct debug_sym {
   CHAR *symName;
   U16  segment;
   U32  offset;
   U8   symClass;
   TYPE_INDEX typeIndex;
   struct debug_sym FAR *next;
} DEBUG_SYM;


                       /****************************
                        *                          *
                        *      PROTOTYPES          *
                        *                          *
                        ****************************/


/* OMF86.CPP routines */
RETCODE GetIndex(HANDLE hFile, U16 *index);
RETCODE GetPhysicalBase(HANDLE hFile, LADDRESS *addrPtr);
RETCODE GetBaseOffset(HANDLE hFile, LADDRESS *basePtr);
RETCODE GetBase(HANDLE hFile, LADDRESS *basePtr);

/* DATA.CPP routines */
RETCODE ProcessREGINT(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessPIDATA(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessPEDATA(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessRIDATA(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessREDATA(OMF86_FUNC_PARA *funcPara);

/* DEBUG.CPP routines */
RETCODE ProcessTHEADR(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessLINNUM(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessPUBDEF(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessBLKDEF(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessBLKEND(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessDEBSYM(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessMODEND(OMF86_FUNC_PARA *funcPara);
RETCODE ProcessLOCSYM(OMF86_FUNC_PARA *funcPara);
VOID InitModuleParam(VOID);
RETCODE LoadModuleEnd(OMF86_FUNC_PARA *funcPara);
RETCODE FreePublics(RETCODE err);
RETCODE LoadPublics(OMF86_FUNC_PARA *funcPara);

/* FILE.CPP routines */
U32 CurrentLocation(VOID);
RETCODE OMFOpenFile(LPSTR , HANDLE *, OFSTRUCT *);
RETCODE OMFCloseFile(HANDLE);
RETCODE OMFGetByte(HANDLE hFile, U8 *pByte);
RETCODE OMFGetBytes(HANDLE hFile, U8 *pByte, U16 number);
RETCODE Flush(HANDLE hFile, U32 endLoc);
RETCODE CheckChecksum(HANDLE hFile);
S32 SeekFile(HANDLE hfile, S32 pos, S16 seekTo);
RETCODE SkipOver(HANDLE, U32, U8 );

/* REGTBL.CPP routines */
RETCODE SetupRegisterTable(VOID);
RETCODE GetRegID(U16 reg, U16 FAR *cpuRegId);
RETCODE CheckRegisterIndex(U16 reg);

#endif /* __OMF86LDR__ */
/******************************** E O F ***********************************/
