/****************************************************************************
**
**  Name:  testfunc.h
**
**  Description:
**     Include file for peripheral test functions used in internal
**     iterators.
**
**  $Log:   S:/tbird/arcm332/peri/testfunc.h_v  $
** 
**    Rev 1.3   04 Oct 1993 16:40:10   marilyn
** Additional matching functions.
** 
**    Rev 1.2   23 Sep 1993 11:01:38   marilyn
** Additional test function added.
** 
**    Rev 1.1   23 Aug 1993 12:20:16   marilyn
** Added TLine functions.
** 
**    Rev 1.0   28 Jun 1993 15:07:42   marilyn
** Initial revision.
**  
**  $Header:   S:/tbird/arcm332/peri/testfunc.h_v   1.3   04 Oct 1993 16:40:10   marilyn  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TESTFUNC_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLASSTYP_
#include "classtyp.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


		       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/



// firstThat test functions
int MatchesTGroupId(const Object& thisObject,VOID *thisId);

int MatchesTGroupRange(const Object& thisObject,VOID *searchAddrDesc);

int TGroupRangeGTAddr(const Object& thisObject,VOID *searchAddrDesc);

int MatchesTGroupName(const Object& thisObject,VOID *groupName);

int MatchesOrLTTRegIdByAddr(const Object& thisObject,VOID *searchAddr);

int MatchesTLineKey(const Object& thisObject,VOID *lineObject);

int MatchesTLineRange(const Object& thisObject,VOID *line);

int MatchesTDisplayGroupId(const Object& thisObject,VOID *groupId);

int MatchesTDisplayRegId(const Object& thisObject,VOID *regId);

// forEach iterative functions
VOID ResetTGroupBase(Object& thisObject,VOID *base);

VOID SetTRegisterView(Object& thisObject,VOID *view);

VOID FreeTRegister(Object& thisObject,VOID *);

VOID SetTRegisterDirty(Object& thisObject,VOID *);


//************************* E O F ****************************************