#include "windows.h"
#include "windowsx.h"
#include "vlist.h"

#ifdef WIN32
#define EXPORT
#else
#define EXPORT _export
#endif
typedef struct tagVLISTBox
   {
      HWND      hwnd;             // hwnd of this VLIST box
      int       nId;              // Id of Control
      HINSTANCE hInstance;        // Instance of parent
      HWND      hwndParent;       // hwnd of parent of VLIST box
      HWND      hwndList;         // hwnd of List box
      WNDPROC   lpfnLBWndProc;    // Window procedure of list box
      int       nchHeight;        // Height of text line
      int       nLines;           // Number of lines in listbox
      LONG      styleSave;        // Save the Style Bits
      WORD      VLBoxStyle;       // List Box Style
      HANDLE    hFont;            // Font for List box
      LONG      lToplIndex;      // Top logical record number;
      int       nCountInBox;      // Number of Items in box.
      LONG      lNumLogicalRecs;  // Number of logical records
      VLBSTRUCT vlbStruct;        // Buffer to communicate to app
      WORD      wFlags;           // Various flags fot the VLB
                                  //
                                  // 0x01 - HasStrings
                                  // 0x02 - Use Data Values
                                  // 0x04 - Multiple Selections
                                  // 0x08 - Ok for parent to have focus
                                  // 0x10 - Control has focus

      LONG      lSelItem;         // List of selected items
      int       nvlbRedrawState;  // Redraw State
      BOOL      bHScrollBar;      // Does it have a H Scroll
} VLBOX;

// typedef VLBOX NEAR *PVLBOX;
typedef VLBOX FAR  *LPVLBOX;


#define IDS_VLBOXNAME  1
#define VLBLBOXID      100
#define VLBEDITID      101

#define HASSTRINGS     0x01       // List box stores strings
#define USEDATAVALUES  0x02       // Use Data Values to talk to parent
#define MULTIPLESEL    0x04       // VLB has extended or multiple selection
#define PARENTFOCUS    0x08       // Ok for parent to have focus
#define HASFOCUS       0x10       // 0x10 - Control has focus

LRESULT EXPORT WINAPI VListBoxWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT EXPORT WINAPI LBSubclassProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

BOOL WINAPI RegisterVListBox();
LONG VLBMessageItemHandler( LPVLBOX lpVLBox,  UINT message, LPSTR lpfoo);
LONG VLBParentMessageHandler( LPVLBOX lpVLBox, UINT message, WPARAM wParam, LPARAM lParam);
LONG VLBNcCreateHandler( HWND hwnd, LPCREATESTRUCT lpcreateStruct);
LONG VLBCreateHandler( LPVLBOX pVListBox, HWND hwnd, LPCREATESTRUCT lpcreateStruct);
void VLBNcDestroyHandler(HWND hwnd,  LPVLBOX pVListBox, WPARAM wParam, LPARAM lParam);
void VLBSetFontHandler( LPVLBOX pVListBox, HANDLE hFont, BOOL fRedraw);
int  VLBScrollDownLine( LPVLBOX lpVLBox);
int  VLBScrollUpLine( LPVLBOX lpVLBox);
int  VLBScrollDownPage( LPVLBOX lpVLBox, int nAdjustment);
int  VLBScrollUpPage( LPVLBOX lpVLBox, int nAdjustment);
void UpdateVLBWindow( LPVLBOX lpVLBox, LPRECT lpRect);
int  VLBFindPage( LPVLBOX lpVLBox, LONG lFindRecNum, BOOL bUpdateTop);
int  VLBFindPos( LPVLBOX lpVLBox, int nPos);
void VLBFirstPage( LPVLBOX lpVLBox);
void VLBLastPage( LPVLBOX lpVLBox);
LONG vlbSetCurSel(LONG nOption, LONG lParam, LPVLBOX lpVLBox);
int  vlbFindData( LPVLBOX lpVLBox, LONG lData);
void VLBSizeHandler( LPVLBOX lpVLBox, int nItemHeight);
int  vlbInVLB( LPVLBOX lpVLBox, LONG lData);
void VLBCountLines( LPVLBOX lpVLBox);

void vlbRedrawOff(LPVLBOX lpVLBox);
void vlbRedrawOn(LPVLBOX lpVLBox);

BOOL TestSelectedItem(LPVLBOX lpVLBox, VLBSTRUCT vlbStruct);
void SetSelectedItem(LPVLBOX lpVLBox);

void vlbPGDN(LPVLBOX lpVLBox);
void vlbPGUP(LPVLBOX lpVLBox);

void vlbLineDn(LPVLBOX lpVLBox);
void vlbLineUp(LPVLBOX lpVLBox);

extern HANDLE  hInstance;              // Global instance handle for  DLL
