/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the SERVERS.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arccore/sds/libmain.c_v  $
** 
**    Rev 1.2   14 May 1992 12:28:50   mindy
** added call to register sdserver with error server
** 
**    Rev 1.1   17 Jan 1992 16:14:30   doug
** return code changed to match prototype
** 
**    Rev 1.0   29 Jul 1991 08:52:50   jim
** Initial revision.
**
**  $Header:   S:/tbird/arccore/sds/libmain.c_v   1.2   14 May 1992 12:28:50   mindy  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the SERVERS.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    ErrInitDLL(MODULE_SHARED_DATA,"sdserver.dll");
    /* initialize successfully */
    hLib = hInstance;
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
