/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the base class library DLL
**
**  $Log:   S:/tbird/arccore/baselib/libmain.cpv  $
** 
**    Rev 1.0   14 Jul 1993 17:30:32   marilyn
** Initial revision.
** 
**
**  $Header:   S:/tbird/arccore/baselib/libmain.cpv   1.0   14 Jul 1993 17:30:32   marilyn  $ 
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#define WIN31
#include <owl.h>


/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
#if defined (STRICT)
HINSTANCE hLib;
#else
HANDLE hLib;
#endif
PTModule BCModule;
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the base class DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
#if defined (STRICT)
int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
#else
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
#endif
    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */

//    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
//     UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    BCModule = new TModule("BaseLib",hInstance,lpszCmdLine);
    err = BCModule->Status;
    if (err != GOOD) {
       BCModule->Error(err);
       delete BCModule;
       BCModule = NULL;
       ErrDisplayError(err, FORCE_POPUP);
    }
    return(TRUE);

}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
int FAR PASCAL WEP(int nParam) {

   return(TRUE);
}
#endif


/******************************** E O F ***********************************/
