/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the BKPTEXEC.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcm030/bkptexec/libmain.c_v  $
** 
**    Rev 1.5   17 Feb 1993 13:39:14   doug
** change name of dummy dll
** 
**    Rev 1.4   27 Jul 1992 23:23:50   brucea
** Made hLib public
** 
**    Rev 1.3   21 Jul 1992 20:55:56   brucea
** Cleaned up LibMain, removed WEP
** 
**    Rev 1.2   15 May 1992 16:08:20   brucea
** Added: two dll names for use by error reporting code
**      : ErrInitDLL call to set up for error text
** 
**    Rev 1.1   26 Mar 1992 18:17:06   brucea
** Comment changes: replaced ENLIB.DLL with BKPTEXEC.DLL
** 
**    Rev 1.0   01 Feb 1992 15:55:58   doug
** Initial revision.
** 
**  $Header:   S:/tbird/arcm030/bkptexec/libmain.c_v   1.5   17 Feb 1993 13:39:14   doug  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _BKPTEXEC_
#include "bkptexec.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#ifndef SDSDUMMY
#define MODULE_NAME "bkptexec.dll"
#else
#define MODULE_NAME "bknohw.dll"
#endif

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the BKPTEXEC.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {
                       
    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;

    ErrInitDLL(MODULE_BREAKPOINT, MODULE_NAME);  /* set up for error text */
    err = BxInit();
    if (GOOD != err)
      ErrDisplayError(err, FORCE_POPUP);

    return(TRUE);
}

/******************************** E O F ***********************************/
