/****************************************************************************
**
**  Name:  bkroot.c
**
**  Description:
**     Breakpoint and Execution Control Server Root DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcm030/bkroot/bkroot.c_v  $
** 
**    Rev 1.4   27 Aug 1992 14:55:58   brucea
** Changed: BX_EMULATION_STATE and BX_CAUSE to use those defined in sdtempl.h
** 
**    Rev 1.3   25 Aug 1992 11:06:58   brucea
** Removed: lpEmulProc var
** 
**    Rev 1.2   31 Jul 1992 10:18:24   mindy
** Added static to avoid initializing server twice.
** 
**    Rev 1.1   22 Jul 1992 16:49:18   doug
** use new generic shared data
** 
**    Rev 1.0   25 Jun 1992 11:17:56   jim
** Initial revision.
** 
**    Rev 1.1   23 Jun 1992 15:45:08   brucea
** Changed: error name to ER_BK... from ER_BX
** 
**    Rev 1.0   22 Jun 1992 19:01:48   brucea
** Initial revision.
**
**  $Header:   S:/tbird/arcm030/bkroot/bkroot.c_v   1.4   27 Aug 1992 14:55:58   brucea  $
**
**  Copyright (C) 1991,92 Microtek International.  All rights reserved.
**
*****************************************************************************/


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
//#include "string.h"

#ifndef _BASEWIND_
#include "basetype.h"
#endif

#ifndef _BKPTEXEC_
#include "bkptexec.h"
#endif

#ifndef _BKROOT_
#include "bkroot.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef  _SDS2ABI_
#include "sds2abi.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL STORAGE        *
                        *                          *
                        ****************************/

PRIVATE DESCRIPTOR emulStateDesc;

/* state variable indicating whether OK to access target processor while it
   is in emulation or not */
PRIVATE BOOLEAN emuRunAccess;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/*---------------------------------------------------------------------------
** BkRootInit
----------------------------------------------------------------------------*/
static BOOLEAN BkRootInitialized = FALSE;
RETCODE EXPORT BkRootInit(VOID) {

   RETCODE err = GOOD;

   /* if initialization already done just return GOOD */
   if( BkRootInitialized ) return(GOOD);
   BkRootInitialized = TRUE;

   err = SdRegister(SD_EMULATION_STATE,
                    NULLPTR,
                    &emulStateDesc);

   emuRunAccess = FALSE;  /* default to not allow emu access while it is
                             in emulation */

   return err;
}  /* end of BkRootInit */


/*---------------------------------------------------------------------------
** BkSetRunAccess - allows user to access target while in emulation
----------------------------------------------------------------------------*/
RETCODE EXPORT BkSetRunAccess(VOID) {

   emuRunAccess = TRUE;
   return GOOD;
}  /* end of BkSetRunAccess */


/*---------------------------------------------------------------------------
** BkClearRunAccess - prevents user from accessing target while in emulation
----------------------------------------------------------------------------*/
RETCODE EXPORT BkClearRunAccess(VOID) {

   emuRunAccess = FALSE;
   return GOOD;
}  /* end of BkClearRunAccess */


/*---------------------------------------------------------------------------
** BkGetRunAccess - returns run access state                       
----------------------------------------------------------------------------*/
RETCODE EXPORT BkGetRunAccess(BOOLEAN *runAccess) {

   *runAccess = emuRunAccess;
   return GOOD;
}  /* end of BkGetRunAccess */


/****************************************************************************
**
**  BkGetEmulationStatus
**
*****************************************************************************/
RETCODE EXPORT BkGetEmulationStatus(EMULATION_STATE FAR *emulState) {

   return(SdReadMember(emulStateDesc, (U8 FAR *)emulState));
}  /* BkGetEmulationStatus */


/****************************************************************************
**
**  BkProcessorMustBeHalted
**
*****************************************************************************/
RETCODE EXPORT
BkProcessorMustBeHalted(VOID) {

   if (!emuRunAccess) {
      return BkProcessorMustBeHaltedAbsolute();
   }
   return(GOOD);
}  /* end of BkProcessorMustBeHalted */


/****************************************************************************
**
**  BkProcessorMustBeHaltedAbsolute
**
*****************************************************************************/
RETCODE EXPORT
BkProcessorMustBeHaltedAbsolute(VOID) {

   RETCODE err;
   EMULATION_STATE emulState;
   S16 status;
   U8 goStatus;

   if((err = BkGetEmulationStatus((EMULATION_STATE FAR *)&emulState))
      !=GOOD) return(err);
   status = iceGetCpuStatus(&goStatus);
   if (goStatus) {
         emulState = EM_HALTED;
//         if ((err = SdnWriteMember(SDN_EMULATION_STATE,(U8*)&emulState,GOOD))
//            != GOOD) return(err);
   }
   if(emulState!=EM_HALTED) {
      return(ER_BK_EMULATOR_MUST_BE_HALTED);
   }
   return(GOOD);
}  /* end of BkProcessorMustBeHaltedAbsolute */


/******************************** E O F ***********************************/
