/****************************************************************************
**
**  Name:  INHEX.H
**
**  Description:
**
**
**  Status:  PRELIMINARY
**
**  $Log:$
** 
**  $Header:$
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __INHEX__
#define __INHEX__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef enum {
   REC_DATA,
   REC_EOF,
   REC_SEG_ADDR,
   REC_START_CSIP,
   REC_EXT_LINEAR_ADDR,
   REC_START_EIP,
   REC_PROT_SEG_MARKER = 0x40, // Phar Lap 32-bit Hex Format
   REC_INI_REG_VALUE   = 0x41  // Phar Lap 32-bit Hex Format
}  REC_TYPE;

typedef struct {
   U32 offset;
   U16 base;
} VIRTUAL_ADDRESS;

#define MIN(a,b)    (((a) < (b)) ? (a) : (b))
#define C2X(c)      (((CHAR)c >= 'A') ? (U8)(10+c-'A') : (U8)(c-'0'))
#define MAX_LINE_LEN      600
#define MAX_VALUE_CHARS     8
#define LDR_BUFSIZE      4096

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
**
**  InHexLoaderLoad
**
**   Description:
**        Load the specified InHex load file, using the input load flags.
**
**   Parameters:
**        input:
**           loadFileName   File name (including path) of the loadfile
**           loadFlags      Load options (combination of one or more load
**                          options: LOAD_CODE, LOAD_SYMBOLS, etc.,)
**           parentHwnd     Parent Window handle (HWND).
**           addrSpace      user's option which is either USER or SMM
**
**        output:
**           none.
**
**   Returns:
**        GOOD on successful load operation
**        if error occurs, an error code is returned to caller.
**
******************************************************************************/
RETCODE EXPORT InHexLoaderLoad(LPSTR loadFileName, U32 loadFlags,
                               HWND parentHwnd,
                               ADDR_SPACE addrSpace);

/*****************************************************************************
**
**  InHexLoaderLoadModuleByDesc
**
**   Description:
**       Dummy function
**
**   Parameters:
**       input:
**          fileName       Filename where module is found
**          moduleName     Name of module to load
**          moduleDesc     Module Descriptor of the specified module
**                         (assigned by the Symbol Server)
**          addrSpace      user's option which is either USER or SMM
**          loadFlags      Load options (combination of one or more load
**                         options: LOAD_CODE, LOAD_SYMBOLS, etc.,)
**
**       output:
**          none.
**
**  Returns:
**       GOOD
**
*****************************************************************************/
RETCODE EXPORT InHexLoaderLoadModuleByDesc(LPSTR fileName, LPSTR moduleName,
                                           SYM_DESCRIPTOR moduleDesc,
                                           ADDR_SPACE addrSpace,
                                           U32 loadFlags);


/*****************************************************************************
**
**  InHexLoaderGetStartPC
**
**  Description:
**     Function to retrieve the loaded loadfile start PC.  This function will
**     allocate the returned address descriptor, Caller is responsible for
**     destroying the descriptor when done.  When error occurs, this function
**     does not return the start PC.
**
**  Parameters:
**     input:
**        none.
**
**     output:
**        ptrStartPC     Pointer to an Address Descriptor.
**
**     Returns:
**        GOOD on successful operation
**        if an error occurred, an error code is returned to caller.
**
******************************************************************************/
RETCODE EXPORT InHexLoaderGetStartPC(DESCRIPTOR FAR *ptrStartPC);

/******************************************************************************
**
**  InHexLoaderGetStackInfo
**
**  Description:
**     Dummy function
**
**  Parameters:
**     input:
**        none.
**
**     output:
**        ptrStackTop   Pointer to address descriptor.
**        stkSize       Pointer to Stack size.
**
**     Returns:
**        GOOD
**
*****************************************************************************/
RETCODE EXPORT InHexLoaderGetStackInfo(DESCRIPTOR FAR *ptrStackTop,
                                       U32 FAR *stkSize);

/*****************************************************************************
**
**  InHexLoaderGetBytes
**
**  Description:
**     Function to get the data blocks for code loading. This
**     function reads loadfile according to the specified size, then
**     copy the contents to the caller.
**
**  Parameters:
**     input:
**        info          Pointer to the handle of the loadfile.
**        count         Size of the contents which this function should read.
**
**     output:
**        dest          Pointer to the returned contents.
**
**     Returns:
**        GOOD on successful operation
**        if an error occurred, an error code is returned to caller.
**
*****************************************************************************/
RETCODE EXPORT InHexLoaderGetBytes(VOID FAR *info, U8 FAR *dest, U16 count);

#ifdef __cplusplus
}
#endif

#endif /* __INHEX__ */
/******************************** E O F ***********************************/
