/****************************************************************************
**
**  Name:  ERR.C
**
**  Description:
**      Error message strings for SRECORD loader.  Entries correspond
**      to error #defines in err.h.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/err.c_v  $
** 
**    Rev 1.12   17 Jun 1994 15:00:24   nghia
** Removed Warning and WarningEx routines.
** 
**    Rev 1.11   03 Jun 1994 16:02:30   nghia
** Removed SendMessageToCLI
** 
**    Rev 1.10   23 May 1994 16:55:40   nghia
** Removed report load status to the Shell.
** 
**    Rev 1.9   18 May 1994 17:07:12   nghia
** Clean up for Loader Launcher integration.
** 
**    Rev 1.8   30 Aug 1993 14:20:36   ron
** removed unused code.
** 
**    Rev 1.7   30 Aug 1993 11:13:08   ron
** Changes for Load Progress dialog
** 
**    Rev 1.6   28 Jun 1993 10:54:36   ron
** changing MessageBox to ErrMessageBox and adding a Help Button/Help Entry
** 
**    Rev 1.5   04 Jun 1993 09:56:14   nghia
** Revised to use the new error code.
** Reported error using only the Warning() and WarningEx() routines.
** PIP for Source.
** 
**    Rev 1.4   12 Feb 1993 17:57:06   nghia
** Updated for release.
** 
**    Rev 1.3   04 Nov 1992 17:39:40   courtney
** Use global RunMode, not runMode.
** 
**    Rev 1.2   22 Oct 1992 16:07:40   courtney
** Revised error reporting functions to go thru Error Text server,
** and handle retcodes instead of PRIVATE strings.
** 
**    Rev 1.1   25 Sep 1992 05:40:16   courtney
** Update routines, add Query and InfoMsg routines.
** 
**    Rev 1.0   31 Dec 1991 09:36:40   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/loader/srec/err.c_v   1.12   17 Jun 1994 15:00:24   nghia  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

#ifndef __SLDR__
#include "sldr.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
/* Note that indiscriminate use of 'char *' type parameters will have
   different effects depending on the memory model used to build this.
   I am assuming Compact model (char * becomes LPSTR).
*/

extern HANDLE cliServerHandle;
extern HANDLE dllServerHandle;
extern U32 ldrFlags;            // defined in SREC.C

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/******************************************************************************
**
**  Query
**
******************************************************************************/
U16 Query(RETCODE ret) {
   S16 status;

   ErrDisplayErrorEx(ret, CHECK_MODE, MB_OKCANCEL | MB_ICONQUESTION,
       (S16 FAR *)&status);

   if (status == IDOK)
      return (QOK);
   else if (status == IDCANCEL)
      return (QCANCEL);

   /* default action is to abort the load process */
   return (QCANCEL);
}  /* Query */

/*********************************** E O F ***********************************/
