/****************************************************************************
**
**  Name:  LFLAGS.H
**
**  Description:
**      Flags used by modules for on-demand loading.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/lflags.h_v  $
** 
**    Rev 1.5   18 May 1994 17:11:12   nghia
** Cleanup for Loader Launcher integration.
** 
**    Rev 1.4   13 Jul 1993 09:41:10   ernie
** Added include of sldrsvr.h to get definition of L695_WARNING
** 
**    Rev 1.3   04 Jun 1993 10:06:42   nghia
** Revised all loader flags macros to meet coding standard.
** PIP for Source.
** 
**    Rev 1.2   12 Feb 1993 17:58:46   nghia
** No change.
** 
**    Rev 1.1   25 Sep 1992 21:06:20   courtney
** Added reload macro.
** 
**    Rev 1.0   31 Dec 1991 09:30:36   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/loader/srec/lflags.h_v   1.5   18 May 1994 17:11:12   nghia  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LFLAGS__
#define __LFLAGS__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* These flags indicate what to load, they can be or'ed together
   to load everything - used internal to the Loader. */
#define L695_GLOBALS    0x01
#define L695_LOCALS     0x02

#define LOAD_GLOBALS(flags) ((flags) & L695_GLOBALS)
#define LOAD_LOCALS(flags)  ((flags) & L695_LOCALS)

/* How to process a module */
#define MCREATE			1	/* create entry in symbol table */
#define MOPEN			2	/* re-open (has already been created) - used
							   in ondemand loading */

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#endif /* __LFLAGS__ */
/******************************** E O F *************************************/

