/****************************************************************************
**
**  Name:  SLDR.H
**
**  Description:
**      All Srecord Loader API's (external entry points) have the prefix: SLD
**      Major header file used by the Srecord Loader
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/sldr.h_v  $
** 
**    Rev 1.13   14 Jul 1994 10:56:50   nghia
** Added load address space.
** 
**    Rev 1.12   17 Jun 1994 15:27:50   nghia
** Removed old junk. Revised symbol processing functions prototype.
** 
**    Rev 1.11   18 May 1994 17:15:34   nghia
** Cleanup for Loader Launcher integration.
** Removed old junks.
** 
**    Rev 1.10   13 Jul 1993 09:45:44   ernie
** Removed prototypes for unused routines in sdata.c
** 
**    Rev 1.9   04 Jun 1993 10:25:48   nghia
** Revised to meet coding standard.
** PIP for Source.
** 
**    Rev 1.8   12 Feb 1993 18:23:52   nghia
** Updated system types.
** Cleanup messes.
** 
**    Rev 1.7   06 Nov 1992 17:34:22   courtney
** Update local nSections after freeing.
** 
**    Rev 1.6   22 Oct 1992 17:19:18   courtney
** Revise prototype to ProcessSymbols to take flag.
** 
**    Rev 1.5   22 Oct 1992 16:12:30   courtney
** Revised prototypes for local error reporting functions.
** 
**    Rev 1.4   25 Sep 1992 21:06:32   courtney
** Added symbol support.
** 
**    Rev 1.3   25 Sep 1992 05:54:58   courtney
** Add prototypes.
** 
**    Rev 1.2   25 Sep 1992 05:43:00   courtney
** Remove handles from structs (using TMalloc); update protos.
** 
**    Rev 1.1   21 Aug 1992 10:26:58   courtney
** Update for 332 support, update CodeBuf structure (copied from 695
** Loader).
** 
**    Rev 1.0   31 Dec 1991 09:37:14   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/loader/srec/sldr.h_v   1.13   14 Jul 1994 10:56:50   nghia  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __SLDR__
#define __SLDR__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>
#include <string.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef __SLRECORD__
#include "slrecord.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_RECLEN  255
#define MAX_ASC_LENGTH  21

#define PATHLEN  128
#define INITIAL_CH	0xff	/* initial value for pushback ch */
#define UNUSED  0xffff		/* initial value for code buffer section index */
#define BYTE_MASK  0x00ff	/* mask for value returned from Get695Byte */

#define MAX_SECTIONS  3
#define SBASE_CODE    "code"
#define SBASE_SYMBOL  "symbol"
#define SCODE_INDEX   1  
#define SSYM_INDEX    2  

/* values for optional AD field */
#define BYTE_ORDER_8086	0xcc
#define BYTE_ORDER_68K	0xcd

/* section type info */
typedef struct {
	char 	name[IEEE_IDNLEN];  /* section name */
	U16	sindex;				  /* section index */
   U16	type;	              /* type (absolute/relocatable) */
	U16	modifier;           /* modifier (code/ROM/data) */
	U16	align;              /* alignment */
	U32	size;	              /* size */
	U32	offset;             /* section base offset */
} SEC_INFO;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/* routines local to DLL */
S16 ProcessHdr(HANDLE);

/* SSECTION.C routines */
S16 ProcessSecPart(U16);
RETCODE FreeSections(U16 *);

/* SDATA.C routines */
RETCODE ProcessDataPart(FILE *, U32 *, ADDR_SPACE);

/* SSYM.C routines */
RETCODE ProcessSymbols(FILE *, U32 *, BOOLEAN);
RETCODE ProcessGlobalSyms(S8 *);

/* SLRECORD.C routines */
S16 MatchRecord(HANDLE, U16, U16);
S16 Match2Record(HANDLE, U16, U16);
S16 Get695Number(HANDLE, U16 *);
S16 Get695Offset(HANDLE, U32 *);
S16 Get695TIndex(HANDLE, U32 *, U32);
S16 Get695Idn(HANDLE, LPSTR);
S16 Get695LongIdn(VOID);
S16 Get695Op(VOID);
S16 Get695Byte(HANDLE, U16 *);
S16 Peek695Byte(HANDLE, U16 *);
VOID Clear695Byte(VOID);
VOID Unget695Byte(HANDLE, U16);
S16 GetCodeSrec(S16, U8 *);
VOID InitHexTable(VOID);
S16 GetSrec(FILE *, U8 *);
S16 SrecType(U8 *);
VOID PushSrec(U8 *);
U8 *NextPair(U8 *, U16 *);
S8 *NextAddr(S8 *, U16, U32 *);
S8 *GetModule(S8 *, S8 *);

/* MACRO */
#define HEX_TO_BIN(c) (isdigit(c) ? (c) - '0' : (c) - 'A' + 10)

#endif /* __SLDR__ */
/******************************** E O F *************************************/
