/****************************************************************************
**
**  Name:  SREC.C
**
**  Description:
**      Entry points for the Srecord loader.
**      Primary API's live here.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/srec.c_v  $
** 
**    Rev 1.22   11 Oct 1994 10:32:42   nghia
** Added loadOption parameter to SRecLoaderLaodModuleByDesc().
** 
**    Rev 1.21   18 Aug 1994 11:39:44   nghia
** Moved events notification to Loader Launcher.
** 
**    Rev 1.20   14 Jul 1994 10:58:42   nghia
** Added load address space to interface functions.
** 
**    Rev 1.19   17 Jun 1994 15:05:06   nghia
** Revised to used LdrWarning().  Revised CLI init routine.
** Revised Set Symbol Type to handle 68k family.
** 
**    Rev 1.18   03 Jun 1994 16:03:06   nghia
** Used LdrSendMessageToCLI to output message.
** 
**    Rev 1.17   23 May 1994 16:54:54   nghia
** Revised to use the common service to report load status to the Shell.
** 
**    Rev 1.16   18 May 1994 17:18:16   nghia
** Cleanup for Loader Launcher integration.
** Removed old junks.
** Provided external interfaces as the Loader Launcher specified.
** Removed dependencies of other DLL.
** 
**    Rev 1.15   30 Aug 1993 11:13:24   ron
** Changes for Load Progress dialog
** 
**    Rev 1.14   28 Jul 1993 11:06:46   courtney
** Macros REPORT_* now correctly set boolean value for loader state
** variables; SymRemoveSymbols *always* will get called before each
** load, since SymAddLoadStart fails to recognize symbols have already
** been loaded for Srecord loadfiles (bug); FreeSections called once
** only in normal load case (not tied to symbol loading).
** 
**    Rev 1.13   26 Jul 1993 09:39:50   ernie
** Fixed error code returned to shell when symbols already loaded.
** 
**    Rev 1.12   26 Jul 1993 08:50:38   ernie
** Removed EVENT_MEM_EDIT.  This is now propagated by EVENT_LDR_MEMCHANGED.
** 
**    Rev 1.11   13 Jul 1993 09:42:44   ernie
** 1. Removed call to InitHexTable--this is now statically initialized.
** 2. Removed calls to register codebufs--these are no longer used.
** 3. Added event EVENT_LDR_MEMCHANGED to inform the memory server that
**    the loader has modified memory and that its caches should be flushed.
** 4. Added event EVENT_MEM_EDIT to inform presenters that memory was changed.
**    Normally EVENT_LDR_LOADCOMPLETE does this, but this event was removed
**    for other reasons.
** 
**    Rev 1.10   04 Jun 1993 10:30:44   nghia
** Revised to meet coding standard.
** Reported error using only the Warning() and WarningEx() routines.
** Removed dead code. - PIP for Source.
** 
**    Rev 1.9   12 Feb 1993 18:04:52   nghia
** Removed all #if ? and #endif.
** Fixed bug caused memory leakage.
** Fixed bug caused file handle not being closed when user abort or error.
** Updated for release.
** 
**    Rev 1.8   03 Dec 1992 17:45:34   courtney
** Added comment to InitCServer.
** 
**    Rev 1.7   06 Nov 1992 17:34:40   courtney
** Update local nSections after freeing.
** 
**    Rev 1.6   04 Nov 1992 17:40:12   courtney
** Add runMode parameter to entry point (inherits from 695 loader).
** 
**    Rev 1.5   22 Oct 1992 17:18:46   courtney
** Revise parameters to ProcessSymbols to pass symload flag.
** 
**    Rev 1.4   22 Oct 1992 16:13:16   courtney
** Cleanup error reporting to use generic loader's string resource messages.
** 
**    Rev 1.3   25 Sep 1992 21:07:10   courtney
** Added symbol support.
** 
**    Rev 1.2   25 Sep 1992 05:44:08   courtney
** Add PRIVATEs (?not used); add info msg calls; update code; add
** cleanup routine; *no* events.
** 
**    Rev 1.1   21 Aug 1992 10:24:34   courtney
** Update return codes, update (unused) InitCServer to new style.
** 
**    Rev 1.0   31 Dec 1991 09:33:54   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/loader/srec/srec.c_v   1.22   11 Oct 1994 10:32:42   nghia  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <io.h>
#include <fcntl.h>

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _PVTASK_
#include "pvtask.h"
#endif

#ifndef __SLDR__
#include "sldr.h"
#endif

#ifndef __LFLAGS__
#include "lflags.h"
#endif

#ifndef __LSYM__
#include "lsym.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifdef SREC_PERF
#include <time.h>
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#pragma warn -par
CHAR errbuf[80];

// Global to srec
HANDLE cliServerHandle;
HANDLE dllServerHandle;

/*
** PRIVATE data, needs to be retained for event callbacks on code/sym
** load complete
*/
S8  lpLoadfile[PATHLEN];
U32 ldrFlags;
HWND hWnd = NULL;
LPLDRSTATBLOCK lstb = NULL; /* loader status block */
PROCESSOR_FAMILY procFamily = FAMILY_UNKNOWN;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern nSections;
extern S16 numBytesInBuff;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

PRIVATE VOID Cleanup(U32);
                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/*****************************************************************************
**
**  SRecLoaderLoad
**
*****************************************************************************/
RETCODE EXPORT SRecLoaderLoad(LPSTR lpBinfile, U32 flags, HWND parentHwnd,
                              ADDR_SPACE addrSpace) {
   FILE *fpBinfile;      // File Handle
   CHAR pfile[PATHLEN];  /* near buffer */
   RETCODE err;
   U32 nLoaded=0L;
   TIMESTAMP_TYPE mtime_disk;
   RETCODE symerr;
   U16 status;
   BOOLEAN abortFromEsc;
   CHAR *lpStrTmp;
   
#ifdef SREC_PERF
   // To measure loader download performance
   time_t first, second;
   first = time(NULL);
#endif

   /* Set/Clear initial state for user-abort checking */
   if ((err = TskCheckAbort(&abortFromEsc)) != GOOD) {
      LdrProgressDone(err);
      return(err);
   }
   // get pointer to the Loader Launcher STATUSBLOCK to report
   if (((err = LdrGetStatBlock((LPLDRSTATBLOCK FAR *) &lstb)) != GOOD) ||
       (lstb == NULL)) {
      LdrProgressDone(err);
      return(err);
   }      
   // set up statics for callback 
   lstrcpy((LPSTR)lpLoadfile, (LPSTR)lpBinfile);
   lpStrTmp = lpBinfile;
   // make sure it will fit in the status buffer (and in the dialog)
   // adjust the length of the text string
   while (lstrlen(lpStrTmp) + 1 >= MAX_LOADFILE_NAME_LEN) {
      lpStrTmp++;
   }
   if (lstb != NULL)
      lstrcpy((LPSTR)(lstb->curLoadFile), (LPSTR)lpStrTmp);
   
   ldrFlags = flags;
   hWnd = parentHwnd;

   /* copy filename to near buffer so we can use fopen */
   lstrcpy((LPSTR)pfile, lpBinfile);
   // Open loadfile
   if ((fpBinfile = fopen(pfile, "r")) == NULL) {
       err = ER_CANNOT_OPEN;
       return (err);
	}
   // 05/13/94 - Nghia
   // Set file length for progress indicator
   if (lstb != NULL) {
      fseek(fpBinfile, 0, SEEK_END);
      lstb->loadFileSize = ftell(fpBinfile);
      lstb->curLocation = 0;
   }
   // rewind to the beginning of the file
   fseek(fpBinfile, 0, SEEK_SET);
   // Reset counter of fileBuff
   numBytesInBuff = 0;
   if ((err = LdrGetTimestamp(fileno(fpBinfile), &mtime_disk)) != GOOD)
      return err;

   /*
   ** Even if not loading symbols, need to process symbols if only to
   ** skip over them
   */
   if (IsLoadSymbol(flags)) {
      // The symbol table fails to return SYM ALREADY error for Srecord
      // loads, so we always clear out the symbol table first.
      SymRemoveSymbols();
      symerr = SymAddLoadStart((LPSTR)pfile, INITIAL_LOAD, &mtime_disk);
      /* Check for SYM_ALREADY, query , etc. popup.  Though this currently
         does not work for Srecord loads, that is a BUG and should be fixed.
         Hence this code remains.
      */
      if (symerr == ER_SYMBOLS_LOADED) {
         err = ER_SYM_ALREADY;
         /* Only query if user is capable of response (project presenter
         ** invocation).  If reload option is set from cli invocation, we
         ** just do it.  Else we return error.
         */
         if (IsLoadFromShell(flags)) {
           if (IsReload(flags) || !IsReportWarning(flags)) {
              status = QOK;
           } else {
              fclose(fpBinfile);
              return (ER_SYM_ALREADY_CLI);
           }
         }
         else {  
            if (IsReportWarning(flags)) {
               status = Query(err);
            } else {
               status = QOK;
            }
         }

         if (status == QOK) {
            // unload symbols from Symbol Server 
            SymRemoveSymbols();
            // clear static data from Ldr - try again 
            symerr = SymAddLoadStart((LPSTR)pfile, INITIAL_LOAD, &mtime_disk);
            if (symerr == ER_SYMBOLS_LOADED) {
               // cannot clear symbol server - exit
               fclose(fpBinfile);
               return (err);
            }
         } else if (status == QCANCEL) {
            fclose(fpBinfile);
            return (err);
         } else {
            /* unrecognized error probably from CLI */
            fclose(fpBinfile);
            return (err);
         }
      } /* End of symErr */
      /* Need to overwrite standard int types:
      ** Need to verify processor with proc.dll - these values reflect
      ** 68K family
      */
      if (procFamily == FAMILY_68K) {
         SymAddTypeOverwriteSize((U8)T695_INT, (U8)SZ_STACKPUSH_68K);
         SymAddTypeOverwriteSize((U8)T695_UNS, (U8)SZ_STACKPUSH_68K);
         SymAddTypeOverwriteSize((U8)T695_UNS_INT, (U8)SZ_STACKPUSH_68K);
      }
   }  

   // Process even if nosym/nocode - It allocate memory
   ProcessSecPart(IsLoadSymbol(flags));
   if (lstb != NULL)
      lstb->curLocation = ftell(fpBinfile); 
   if ((err = ProcessSymbols(fpBinfile, &nLoaded,
                             IsLoadSymbol(flags))) != GOOD) {
      /* check for user abort (within routine) */
      fclose(fpBinfile);
      SymAddLoadEnd();
      FreeSections((U16 *) &nSections);
      LdrProgressDone(err);
      return(err);  /* exit */
   }

   if (IsLoadSymbol(flags)) {
      if (((symerr = SymAddLoadEnd()) != GOOD) &&
          ((err = LdrWarning(symerr, NULL, NULL, NULL)) != GOOD))
          return LdrProgressDone(err);
   }

   /* check for user abort */
   if ((err = TskCheckAbort(&abortFromEsc)) != GOOD) {
      LdrProgressDone(err);
      fclose(fpBinfile);
      Cleanup(flags);
      return(ER_LDR_ABORT);
   }

   if (IsLoadCode(flags)) {
      nLoaded = 0L;
      /* should now be positioned to process srecords */
      /* process and load code and constant data records */
      if (lstb != NULL)
         lstb->curLocation = ftell(fpBinfile);
      
      if ((err = ProcessDataPart(fpBinfile, &nLoaded, addrSpace)) != GOOD) {
         LdrProgressDone(err);
         fclose(fpBinfile);
         Cleanup(flags);
         return(err);  /* exit */
      }
#ifdef SREC_PERF
      second = time(NULL);
      wsprintf(errbuf, "Load %ld bytes in %ld seconds", lstb->numBytes,
         second-first);
      LdrSendMessageToCLI(errbuf);
#endif

   }
   fclose(fpBinfile);
   FreeSections((U16 *) &nSections);
   LdrProgressDone(err);
   return err;
}  /* SRecLoaderLoad */

/********************************************************************************
**
**  SRecLoaderLoadModuleByDesc
**
******************************************************************************/
RETCODE EXPORT SRecLoaderLoadModuleByDesc(LPSTR lpBinfile, LPSTR moduleName,
                                          SYM_DESCRIPTOR moduleDesc,
                                          ADDR_SPACE loadAddrSpace,
                                          U32 flags) {
   // Conform to the Loader Launcher Specification   
   return ER_NOTYET_IMPL;
} /* SRecLoaderLoadModuleByDesc */

/******************************************************************************
**
**  SRecLoaderGetStartPC
**
******************************************************************************/
RETCODE EXPORT SRecLoaderGetStartPC(DESCRIPTOR FAR *pstartPC) {
   // Conform to the Loader Launcher Specification
   return ER_NOTYET_IMPL;
} /* SRecLoaderGetStartPC */

/******************************************************************************
**
**  SRecLoaderGetStackInfo
**
******************************************************************************/
RETCODE EXPORT SRecLoaderGetStackInfo(DESCRIPTOR FAR *pstackTop, U32 *ssize) {
   // Conform to the Loader Launcher Specification
   return ER_NOTYET_IMPL;
} /* SRecLoaderGetStackInfo */

/*****************************************************************************
**
**  InitCServer
**
*****************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
	CSERVER_NEW_REGISTRATION FAR *msgBufPtr;

	/* capture these */
	cliServerHandle = cliHandle;
	dllServerHandle = dllHandle;

   msgBufPtr = (CSERVER_NEW_REGISTRATION FAR *)
            TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return(ER_OUT_OF_MEMORY);
   }

   msgBufPtr->stringResourceHandle = dllHandle;

   /* SREC.DLL has no CLI commands */
   msgBufPtr->serverNameIndex       = 0;
   msgBufPtr->dllNameIndex          = 1;
   msgBufPtr->numberOfCommandsIndex = 2;
   msgBufPtr->commandStartIndex     = 3;

   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION, CLI_NEW_SVR_REGISTRATION,
      (DWORD)msgBufPtr);

   return(GOOD);
}  /* InitCServer */

/*****************************************************************************
**
**  Cleanup
**
*****************************************************************************/
PRIVATE VOID Cleanup(U32 flags) {
   RETCODE symerr;
  
   if (IsLoadSymbol(flags)) {
      if ((symerr = SymAddLoadEnd()) != GOOD) 
         LdrWarning(symerr, NULL, NULL, NULL);
      // Remove all symbols 
      SymRemoveSymbols();  // lets clean up the Symbol Server
   }
   // Always free Section info
   FreeSections((U16 *) &nSections);
}  /* Cleanup */

/********************************** E O F ***********************************/
